//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ApplicationClient contains the methods for the Application group.
// Don't use this type directly, use NewApplicationClient() instead.
type ApplicationClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewApplicationClient creates a new instance of ApplicationClient with the specified values.
// subscriptionID - Azure subscription ID
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewApplicationClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ApplicationClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ApplicationClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or update a security application on the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-07-01-preview
// applicationID - The security Application key - unique key for the standard application
// application - Application over a subscription scope
// options - ApplicationClientCreateOrUpdateOptions contains the optional parameters for the ApplicationClient.CreateOrUpdate
// method.
func (client *ApplicationClient) CreateOrUpdate(ctx context.Context, applicationID string, application Application, options *ApplicationClientCreateOrUpdateOptions) (ApplicationClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, applicationID, application, options)
	if err != nil {
		return ApplicationClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ApplicationClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ApplicationClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ApplicationClient) createOrUpdateCreateRequest(ctx context.Context, applicationID string, application Application, options *ApplicationClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if applicationID == "" {
		return nil, errors.New("parameter applicationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationId}", url.PathEscape(applicationID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, application)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ApplicationClient) createOrUpdateHandleResponse(resp *http.Response) (ApplicationClientCreateOrUpdateResponse, error) {
	result := ApplicationClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Application); err != nil {
		return ApplicationClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete an Application over a given scope
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-07-01-preview
// applicationID - The security Application key - unique key for the standard application
// options - ApplicationClientDeleteOptions contains the optional parameters for the ApplicationClient.Delete method.
func (client *ApplicationClient) Delete(ctx context.Context, applicationID string, options *ApplicationClientDeleteOptions) (ApplicationClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, applicationID, options)
	if err != nil {
		return ApplicationClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ApplicationClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ApplicationClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ApplicationClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ApplicationClient) deleteCreateRequest(ctx context.Context, applicationID string, options *ApplicationClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if applicationID == "" {
		return nil, errors.New("parameter applicationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationId}", url.PathEscape(applicationID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Get a specific application for the requested scope by applicationId
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-07-01-preview
// applicationID - The security Application key - unique key for the standard application
// options - ApplicationClientGetOptions contains the optional parameters for the ApplicationClient.Get method.
func (client *ApplicationClient) Get(ctx context.Context, applicationID string, options *ApplicationClientGetOptions) (ApplicationClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, applicationID, options)
	if err != nil {
		return ApplicationClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ApplicationClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ApplicationClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ApplicationClient) getCreateRequest(ctx context.Context, applicationID string, options *ApplicationClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/applications/{applicationId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if applicationID == "" {
		return nil, errors.New("parameter applicationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationId}", url.PathEscape(applicationID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ApplicationClient) getHandleResponse(resp *http.Response) (ApplicationClientGetResponse, error) {
	result := ApplicationClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Application); err != nil {
		return ApplicationClientGetResponse{}, err
	}
	return result, nil
}
