//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databoxedge/armdataboxedge"
	"net/http"
	"net/url"
	"regexp"
)

// DeviceCapacityInfoServer is a fake server for instances of the armdataboxedge.DeviceCapacityInfoClient type.
type DeviceCapacityInfoServer struct {
	// GetDeviceCapacityInfo is the fake for method DeviceCapacityInfoClient.GetDeviceCapacityInfo
	// HTTP status codes to indicate success: http.StatusOK
	GetDeviceCapacityInfo func(ctx context.Context, resourceGroupName string, deviceName string, options *armdataboxedge.DeviceCapacityInfoClientGetDeviceCapacityInfoOptions) (resp azfake.Responder[armdataboxedge.DeviceCapacityInfoClientGetDeviceCapacityInfoResponse], errResp azfake.ErrorResponder)
}

// NewDeviceCapacityInfoServerTransport creates a new instance of DeviceCapacityInfoServerTransport with the provided implementation.
// The returned DeviceCapacityInfoServerTransport instance is connected to an instance of armdataboxedge.DeviceCapacityInfoClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeviceCapacityInfoServerTransport(srv *DeviceCapacityInfoServer) *DeviceCapacityInfoServerTransport {
	return &DeviceCapacityInfoServerTransport{srv: srv}
}

// DeviceCapacityInfoServerTransport connects instances of armdataboxedge.DeviceCapacityInfoClient to instances of DeviceCapacityInfoServer.
// Don't use this type directly, use NewDeviceCapacityInfoServerTransport instead.
type DeviceCapacityInfoServerTransport struct {
	srv *DeviceCapacityInfoServer
}

// Do implements the policy.Transporter interface for DeviceCapacityInfoServerTransport.
func (d *DeviceCapacityInfoServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeviceCapacityInfoClient.GetDeviceCapacityInfo":
		resp, err = d.dispatchGetDeviceCapacityInfo(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeviceCapacityInfoServerTransport) dispatchGetDeviceCapacityInfo(req *http.Request) (*http.Response, error) {
	if d.srv.GetDeviceCapacityInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeviceCapacityInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataBoxEdge/dataBoxEdgeDevices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deviceCapacityInfo/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetDeviceCapacityInfo(req.Context(), resourceGroupNameParam, deviceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeviceCapacityInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
