//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/SecurityContacts/GetSecurityContactsSubscription_example.json
func ExampleContactsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewContactsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ContactList = armsecurity.ContactList{
		// 	Value: []*armsecurity.Contact{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Security/securityContact"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/securityContact/default"),
		// 			Properties: &armsecurity.ContactProperties{
		// 				AlertNotifications: &armsecurity.ContactPropertiesAlertNotifications{
		// 					MinimalSeverity: to.Ptr(armsecurity.MinimalSeverityLow),
		// 					State: to.Ptr(armsecurity.State("On")),
		// 				},
		// 				Emails: to.Ptr("john@contoso.com;Jane@contoso.com"),
		// 				NotificationsByRole: &armsecurity.ContactPropertiesNotificationsByRole{
		// 					Roles: []*armsecurity.Roles{
		// 						to.Ptr(armsecurity.RolesOwner),
		// 						to.Ptr(armsecurity.Roles("Admin"))},
		// 						State: to.Ptr(armsecurity.State("On")),
		// 					},
		// 					Phone: to.Ptr("(214)275-4038"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/SecurityContacts/GetSecurityContact_example.json
func ExampleContactsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContactsClient().Get(ctx, "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Contact = armsecurity.Contact{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Security/securityContacts"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/securityContacts/default"),
	// 	Properties: &armsecurity.ContactProperties{
	// 		AlertNotifications: &armsecurity.ContactPropertiesAlertNotifications{
	// 			MinimalSeverity: to.Ptr(armsecurity.MinimalSeverityLow),
	// 			State: to.Ptr(armsecurity.State("On")),
	// 		},
	// 		Emails: to.Ptr("john@contoso.com;jane@contoso.com"),
	// 		NotificationsByRole: &armsecurity.ContactPropertiesNotificationsByRole{
	// 			Roles: []*armsecurity.Roles{
	// 				to.Ptr(armsecurity.RolesOwner)},
	// 				State: to.Ptr(armsecurity.State("On")),
	// 			},
	// 			Phone: to.Ptr("(214)275-4038"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/SecurityContacts/CreateSecurityContact_example.json
func ExampleContactsClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContactsClient().Create(ctx, "default", armsecurity.Contact{
		Properties: &armsecurity.ContactProperties{
			AlertNotifications: &armsecurity.ContactPropertiesAlertNotifications{
				MinimalSeverity: to.Ptr(armsecurity.MinimalSeverityLow),
				State:           to.Ptr(armsecurity.State("On")),
			},
			Emails: to.Ptr("john@contoso.com;jane@contoso.com"),
			NotificationsByRole: &armsecurity.ContactPropertiesNotificationsByRole{
				Roles: []*armsecurity.Roles{
					to.Ptr(armsecurity.RolesOwner)},
				State: to.Ptr(armsecurity.State("On")),
			},
			Phone: to.Ptr("(214)275-4038"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Contact = armsecurity.Contact{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Security/securityContact"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/securityContacts/default"),
	// 	Properties: &armsecurity.ContactProperties{
	// 		AlertNotifications: &armsecurity.ContactPropertiesAlertNotifications{
	// 			MinimalSeverity: to.Ptr(armsecurity.MinimalSeverityLow),
	// 			State: to.Ptr(armsecurity.State("On")),
	// 		},
	// 		Emails: to.Ptr("john@microsoft.com;jane@microsoft.com"),
	// 		NotificationsByRole: &armsecurity.ContactPropertiesNotificationsByRole{
	// 			Roles: []*armsecurity.Roles{
	// 				to.Ptr(armsecurity.RolesOwner)},
	// 				State: to.Ptr(armsecurity.State("On")),
	// 			},
	// 			Phone: to.Ptr("(214)275-4038"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/SecurityContacts/DeleteSecurityContact_example.json
func ExampleContactsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewContactsClient().Delete(ctx, "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
