#   Copyright (C) 2025 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.

__all__ = ["main"]

_description_ = "Launch back-end and keep pinging it."


import time
import logging
import tempfile

from .common import mk_ping, Backend, prepend

logging.basicConfig(level=logging.ERROR)
logger = logging.getLogger("testing")


def main():
    print(_description_)

    logger.setLevel(logging.INFO)
    with tempfile.TemporaryDirectory() as tmpdirname:
        with Backend(0, tmpdirname) as (mx_send, _, receive):
            ping = mk_ping(mx_send, receive)
            while 1:
                ping()
                time.sleep(1)
