#! /usr/bin/env python3
#
# Copyright © 2024 Collabora Ltd. and Red Hat Inc.
# SPDX-License-Identifier: MIT

# This script takes a list of Rust files, each of the form nvh_path_to_mod.rs
# and constructs a lib.rs which puts each of them in ::path::to::mod.

import argparse
import sys

from mako.template import Template

TEMPLATE_RS = Template("""\
// Copyright © 2024 Collabora Ltd. and Red Hat Inc.
// SPDX-License-Identifier: MIT

// This file is generated by lib_rs_gen.py. DO NOT EDIT!

% for mod in mods:
pub mod ${mod};
% endfor
""")

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-p', '--import-path', required=True)
    parser.add_argument('--out-rs', required=True, help='Output Rust file.')
    parser.add_argument('mods', metavar='MOD', nargs='*',
                        action='append', help='Submodule')
    args = parser.parse_args()

    sys.path.insert(0, args.import_path)
    import util

    util.write_template_rs(args.out_rs, TEMPLATE_RS, dict(mods=args.mods[0]))

if __name__ == '__main__':
    main()
