// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Buildable, IconSize, ImageType, Misc, Widget};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GtkImage")]
    pub struct Image(Object<ffi::GtkImage, ffi::GtkImageClass>) @extends Misc, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_image_get_type(),
    }
}

impl Image {
    pub const NONE: Option<&'static Image> = None;

    #[doc(alias = "gtk_image_new")]
    pub fn new() -> Image {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_image_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_image_new_from_animation")]
    #[doc(alias = "new_from_animation")]
    pub fn from_animation(animation: &impl IsA<gdk_pixbuf::PixbufAnimation>) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_animation(
                animation.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_image_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(filename: impl AsRef<std::path::Path>) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_file(
                filename.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_image_new_from_gicon")]
    #[doc(alias = "new_from_gicon")]
    pub fn from_gicon(icon: &impl IsA<gio::Icon>, size: IconSize) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_gicon(
                icon.as_ref().to_glib_none().0,
                size.into_glib(),
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_image_new_from_icon_name")]
    #[doc(alias = "new_from_icon_name")]
    pub fn from_icon_name(icon_name: Option<&str>, size: IconSize) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_icon_name(
                icon_name.to_glib_none().0,
                size.into_glib(),
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_image_new_from_pixbuf")]
    #[doc(alias = "new_from_pixbuf")]
    pub fn from_pixbuf(pixbuf: Option<&gdk_pixbuf::Pixbuf>) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_pixbuf(pixbuf.to_glib_none().0))
                .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_image_new_from_resource")]
    #[doc(alias = "new_from_resource")]
    pub fn from_resource(resource_path: &str) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_resource(
                resource_path.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_image_new_from_surface")]
    #[doc(alias = "new_from_surface")]
    pub fn from_surface(surface: Option<&cairo::Surface>) -> Image {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_image_new_from_surface(mut_override(
                surface.to_glib_none().0,
            )))
            .unsafe_cast()
        }
    }
}

impl Default for Image {
    fn default() -> Self {
        Self::new()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Image>> Sealed for T {}
}

pub trait ImageExt: IsA<Image> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_image_clear")]
    fn clear(&self) {
        unsafe {
            ffi::gtk_image_clear(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_image_get_animation")]
    #[doc(alias = "get_animation")]
    fn animation(&self) -> Option<gdk_pixbuf::PixbufAnimation> {
        unsafe { from_glib_none(ffi::gtk_image_get_animation(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_image_get_gicon")]
    #[doc(alias = "get_gicon")]
    fn gicon(&self) -> (gio::Icon, IconSize) {
        unsafe {
            let mut gicon = ptr::null_mut();
            let mut size = mem::MaybeUninit::uninit();
            ffi::gtk_image_get_gicon(
                self.as_ref().to_glib_none().0,
                &mut gicon,
                size.as_mut_ptr(),
            );
            (from_glib_none(gicon), from_glib(size.assume_init()))
        }
    }

    #[doc(alias = "gtk_image_get_pixbuf")]
    #[doc(alias = "get_pixbuf")]
    fn pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe { from_glib_none(ffi::gtk_image_get_pixbuf(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_image_get_pixel_size")]
    #[doc(alias = "get_pixel_size")]
    fn pixel_size(&self) -> i32 {
        unsafe { ffi::gtk_image_get_pixel_size(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_image_get_storage_type")]
    #[doc(alias = "get_storage_type")]
    fn storage_type(&self) -> ImageType {
        unsafe {
            from_glib(ffi::gtk_image_get_storage_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_image_set_from_animation")]
    fn set_from_animation(&self, animation: &impl IsA<gdk_pixbuf::PixbufAnimation>) {
        unsafe {
            ffi::gtk_image_set_from_animation(
                self.as_ref().to_glib_none().0,
                animation.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_image_set_from_file")]
    fn set_from_file(&self, filename: Option<impl AsRef<std::path::Path>>) {
        unsafe {
            ffi::gtk_image_set_from_file(
                self.as_ref().to_glib_none().0,
                filename.as_ref().map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_image_set_from_gicon")]
    fn set_from_gicon(&self, icon: &impl IsA<gio::Icon>, size: IconSize) {
        unsafe {
            ffi::gtk_image_set_from_gicon(
                self.as_ref().to_glib_none().0,
                icon.as_ref().to_glib_none().0,
                size.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_image_set_from_icon_name")]
    fn set_from_icon_name(&self, icon_name: Option<&str>, size: IconSize) {
        unsafe {
            ffi::gtk_image_set_from_icon_name(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
                size.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_image_set_from_pixbuf")]
    fn set_from_pixbuf(&self, pixbuf: Option<&gdk_pixbuf::Pixbuf>) {
        unsafe {
            ffi::gtk_image_set_from_pixbuf(self.as_ref().to_glib_none().0, pixbuf.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_image_set_from_resource")]
    fn set_from_resource(&self, resource_path: Option<&str>) {
        unsafe {
            ffi::gtk_image_set_from_resource(
                self.as_ref().to_glib_none().0,
                resource_path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_image_set_from_surface")]
    fn set_from_surface(&self, surface: Option<&cairo::Surface>) {
        unsafe {
            ffi::gtk_image_set_from_surface(
                self.as_ref().to_glib_none().0,
                mut_override(surface.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_image_set_pixel_size")]
    fn set_pixel_size(&self, pixel_size: i32) {
        unsafe {
            ffi::gtk_image_set_pixel_size(self.as_ref().to_glib_none().0, pixel_size);
        }
    }

    fn file(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "file")
    }

    fn set_file(&self, file: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "file", file)
    }

    fn set_gicon<P: IsA<gio::Icon>>(&self, gicon: Option<&P>) {
        ObjectExt::set_property(self.as_ref(), "gicon", gicon)
    }

    #[doc(alias = "icon-name")]
    fn icon_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "icon-name")
    }

    #[doc(alias = "icon-name")]
    fn set_icon_name(&self, icon_name: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "icon-name", icon_name)
    }

    fn set_pixbuf(&self, pixbuf: Option<&gdk_pixbuf::Pixbuf>) {
        ObjectExt::set_property(self.as_ref(), "pixbuf", pixbuf)
    }

    #[doc(alias = "pixbuf-animation")]
    fn pixbuf_animation(&self) -> Option<gdk_pixbuf::PixbufAnimation> {
        ObjectExt::property(self.as_ref(), "pixbuf-animation")
    }

    #[doc(alias = "pixbuf-animation")]
    fn set_pixbuf_animation<P: IsA<gdk_pixbuf::PixbufAnimation>>(
        &self,
        pixbuf_animation: Option<&P>,
    ) {
        ObjectExt::set_property(self.as_ref(), "pixbuf-animation", pixbuf_animation)
    }

    fn resource(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "resource")
    }

    fn set_resource(&self, resource: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "resource", resource)
    }

    fn surface(&self) -> Option<cairo::Surface> {
        ObjectExt::property(self.as_ref(), "surface")
    }

    fn set_surface(&self, surface: Option<&cairo::Surface>) {
        ObjectExt::set_property(self.as_ref(), "surface", surface)
    }

    #[doc(alias = "use-fallback")]
    fn uses_fallback(&self) -> bool {
        ObjectExt::property(self.as_ref(), "use-fallback")
    }

    #[doc(alias = "use-fallback")]
    fn set_use_fallback(&self, use_fallback: bool) {
        ObjectExt::set_property(self.as_ref(), "use-fallback", use_fallback)
    }

    #[doc(alias = "file")]
    fn connect_file_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_file_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::file\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_file_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "gicon")]
    fn connect_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_gicon_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::gicon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixbuf")]
    fn connect_pixbuf_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixbuf_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixbuf\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixbuf_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixbuf-animation")]
    fn connect_pixbuf_animation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixbuf_animation_trampoline<
            P: IsA<Image>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixbuf-animation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixbuf_animation_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixel-size")]
    fn connect_pixel_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixel_size_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixel-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixel_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "resource")]
    fn connect_resource_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resource_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resource\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_resource_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "storage-type")]
    fn connect_storage_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_storage_type_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::storage-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "surface")]
    fn connect_surface_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_surface_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::surface\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_surface_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "use-fallback")]
    fn connect_use_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_fallback_trampoline<P: IsA<Image>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkImage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Image::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-fallback\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_use_fallback_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Image>> ImageExt for O {}

impl fmt::Display for Image {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Image")
    }
}
