% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5T.R
\name{H5T_ops}
\alias{H5T_ops}
\alias{H5Tget_class}
\alias{H5Tget_nmembers}
\title{Get details of HDF5 data types}
\usage{
H5Tget_class(dtype_id)

H5Tget_nmembers(dtype_id)
}
\arguments{
\item{dtype_id}{ID of HDF5 datatype to work with.  Normally created with
a function like \code{H5Tcopy} or \code{H5Tenum_create}.}
}
\value{
\itemize{
\item \code{H5Tget_class()} returns an character vector of length 1 giving the
class of the data type.
\item \code{H5Tget_nmembers()} returns the number of members in the given
datatype.  Will fail with an error if the supplied datatype is not of type
\code{H5T_COMPUND} or \code{H5T_ENUM}.
}
}
\description{
Get details of HDF5 data types
}
\examples{
## create an enum datatype with two entries
tid <- H5Tenum_create(dtype_id = "H5T_NATIVE_UCHAR")
H5Tenum_insert(tid, name = "TRUE", value = 1L)
H5Tenum_insert(tid, name = "FALSE", value = 0L)

H5Tget_class(tid)
H5Tget_nmembers(tid)

}
