% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto-distribution.R
\name{Pareto}
\alias{Pareto}
\alias{dpareto}
\alias{ppareto}
\alias{qpareto}
\alias{rpareto}
\title{Pareto distribution}
\usage{
dpareto(x, a = 1, b = 1, log = FALSE)

ppareto(q, a = 1, b = 1, lower.tail = TRUE, log.p = FALSE)

qpareto(p, a = 1, b = 1, lower.tail = TRUE, log.p = FALSE)

rpareto(n, a = 1, b = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{a, b}{positive valued scale and location parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Pareto distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{ab^a}{x^{a+1}}
}{
f(x) = (a*b^a) / x^(a+1)
}

Cumulative distribution function
\deqn{
F(x) = 1 - \left(\frac{b}{x}\right)^a
}{
F(x) = 1 - (b/x)^a
}

Quantile function
\deqn{
F^{-1}(p) = \frac{b}{(1-p)^{1-a}}
}{
F^-1(p) = b/(1-p)^(1-a)
}
}
\examples{

x <- rpareto(1e5, 5, 16)
hist(x, 100, freq = FALSE)
curve(dpareto(x, 5, 16), 0, 200, col = "red", add = TRUE)
hist(ppareto(x, 5, 16))
plot(ecdf(x))
curve(ppareto(x, 5, 16), 0, 200, col = "red", lwd = 2, add = TRUE)

}
\references{
Krishnamoorthy, K. (2006). Handbook of Statistical Distributions
with Applications. Chapman & Hall/CRC
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
