




<!-- README.md was auto-generated by README.Rmd. Please DO NOT edit by hand!-->

# Luminesence <img width=120px src="man/figures/Luminescence_logo.png" align="right" />

The R package ‘Luminescence’ by the R-Luminescence Group provides a
collection of various R functions for luminescence dating data analysis.

[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![CRAN](https://www.r-pkg.org/badges/version/Luminescence)](https://cran.r-project.org/package=Luminescence)
[![DOI](https://zenodo.org/badge/23153315.svg)](https://zenodo.org/badge/latestdoi/23153315)
[![Downloads](https://cranlogs.r-pkg.org/badges/grand-total/Luminescence)](https://www.r-pkg.org/pkg/Luminescence)
[![Downloads](https://cranlogs.r-pkg.org/badges/Luminescence)](https://www.r-pkg.org/pkg/Luminescence)
[![Downloads](https://cranlogs.r-pkg.org/badges/last-week/Luminescence)](https://www.r-pkg.org/pkg/Luminescence)
[![Downloads](https://cranlogs.r-pkg.org/badges/last-day/Luminescence)](https://www.r-pkg.org/pkg/Luminescence)
[![Build
status](https://ci.appveyor.com/api/projects/status/jtgqr9a6jajn02y0/branch/master?svg=true)](https://ci.appveyor.com/project/tzerk/luminescence/branch/master)
[![Build
Status](https://travis-ci.org/R-Lum/Luminescence.svg?branch=master)](https://travis-ci.org/R-Lum/Luminescence)
[![Coverage
Status](https://img.shields.io/codecov/c/github/R-Lum/Luminescence.svg)](https://codecov.io/github/R-Lum/Luminescence?branch=master)

### CRAN check status

| error | fail | warn | note |  ok |
|------:|-----:|-----:|-----:|----:|
|     5 |    0 |    0 |    4 |   3 |

## Social media and other resources

Follow us on
[![](http://i.imgur.com/wWzX9uB.png)](https://twitter.com/RLuminescence)
or visit our [R-Luminescence homepage](https://r-luminescence.org).

## Installation

#### i. Requirements

-   *Windows (32/64bit)*:
    [Rtools](https://cran.r-project.org/bin/windows/Rtools/) (provided
    by CRAN)
-   *macOS*: [Xcode](https://developer.apple.com/) (provided by Apple)
-   *Linux*: [gcc](https://gcc.gnu.org) often comes pre-installed in
    most distributions.

#### ii. Install the package

Install any development versions using our
[RStudio](https://rstudio.com) add-in

![](man/figures/README-Screenshot_AddIn.png)

##### The plain **R** way

To install the stable version from CRAN, simply run the following from
an R console:

``` r
install.packages("Luminescence")
```

To install the latest development builds directly from GitHub, run

``` r
if(!require("devtools"))
  install.packages("devtools")
devtools::install_github("R-Lum/Luminescence@<wanted branch>")
```

## Contribute

The R luminescence project is based on and evolves from ideas,
contributions and constructive criticism of its users. Help us to
maintain and develop the package, to find bugs and create new functions
as well as a user-friendly design. Try
<https://github.com/R-Lum/Luminescence/issues> or write us an
[e-mail](mailto:developers@r-luminescence.org) if anything crosses your
mind or if you want your new self-written function to be to implemented.
You are kindly invited to bring forward the package with us!

## Note

**The package comes without any guarantee!**

Please further note that this version is a development version and may
change day by day. For stable branches please visit the package on [CRAN
‘Luminescence’](https://CRAN.R-project.org/package=Luminescence).

## License

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or any later
version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the [GNU
General Public
License](https://github.com/R-Lum/Luminescence/blob/master/LICENSE) for
more details.

## Related projects

-   [RLumModel](https://github.com/R-Lum/RLumModel)
-   [RLumShiny](https://github.com/R-Lum/RLumShiny)
-   [RLumDocker](https://github.com/R-Lum/RLumDocker)
-   [BayLum](https://github.com/crp2a/BayLum)
-   [RCarb](https://github.com/R-Lum/RCarb)
-   [RLumCarlo](https://github.com/R-Lum/RLumCarlo)

## R package dependencies

![](man/figures/README-Package_DependencyGraph.png)
