% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_clusterstatus.R
\name{collection_clusterstatus}
\alias{collection_clusterstatus}
\title{Get cluster status}
\usage{
collection_clusterstatus(conn, name = NULL, shard = NULL, raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{shard}{(character) The shard(s) for which information is requested.
Multiple shard names can be specified as a character vector.}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{You can pass in parameters like \code{property.name=value}    to set
core property name to value. See the section Defining core.properties for
details on supported properties and values.
(https://lucene.apache.org/solr/guide/8_2/defining-core-properties.html)}
}
\description{
Fetch the cluster status including collections, shards,
replicas, configuration name as well as collection aliases and cluster
properties.
}
\examples{
\dontrun{
(conn <- SolrClient$new())
conn$collection_clusterstatus()
res <- conn$collection_clusterstatus()
res$responseHeader
res$cluster
res$cluster$collections
res$cluster$collections$gettingstarted
res$cluster$live_nodes
}
}
