% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tidyr_legacy}
\alias{tidyr_legacy}
\title{Legacy name repair}
\usage{
tidyr_legacy(nms, prefix = "V", sep = "")
}
\arguments{
\item{prefix}{prefix Prefix to use for unnamed column}

\item{sep}{Separator to use between name and unique suffix}

\item{nm}{Character vector of names}
}
\description{
Ensures all column names are unique using the approach found in
tidyr 0.8.3 and earlier. Only use this function if you want to preserve
the naming strategy, otherwise you're better off adopting the new
tidyverse standard with \code{name_repair = "universal"}
}
\examples{
df <- tibble(x = 1:2, y = list(tibble(x = 3:5), tibble(x = 4:7)))

# Doesn't work because it would produce a data frame with two
# columns called x
\dontrun{unnest(df, y)}

# The new tidyverse standard:
unnest(df, y, names_repair = "universal")

# The old tidyr approach
unnest(df, y, names_repair = tidyr_legacy)
}
\keyword{internal}
