% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{upload_imgur}
\alias{upload_imgur}
\title{Upload an image to imgur.com}
\usage{
upload_imgur(
  file,
  key = env_option("xfun.upload_imgur.key"),
  use_curl = loadable("curl"),
  include_xml = FALSE
)
}
\arguments{
\item{file}{Path to the image file to be uploaded.}

\item{key}{Client ID for Imgur. It can be set via either the global option
\code{xfun.upload_imgur.key} or the environment variable
\code{R_XFUN_UPLOAD_IMGUR_KEY} (see \code{\link[=env_option]{env_option()}}). If neither is set, this
uses a client ID registered by Yihui Xie.}

\item{use_curl}{Whether to use the R package \pkg{curl} to upload the image.
If \code{FALSE}, the system command \code{curl} will be used.}

\item{include_xml}{Whether to include the XML response in the returned value.}
}
\value{
A character string of the link to the image. If \code{include_xml = TRUE},
this string carries an attribute named \code{XML}, which is the XML response
from Imgur (it will be parsed by \pkg{xml2} if available). See Imgur API in
the references.
}
\description{
This function uses the \pkg{curl} package or the system command \code{curl}
(whichever is available) to upload a image to \url{https://imgur.com}.
}
\details{
One application is to upload local image files to Imgur when knitting a
document with \pkg{knitr}: you can set the \verb{knitr::opts_knit$set(upload.fun = xfun::upload_imgur}, so the output document does not need local image files
any more, and it is ready to be published online.
}
\note{
Please register your own Imgur application to get your client ID. You
can certainly use mine, but this ID is in the public domain and it might
reach Imgur's rate limit if too many people are using it in the same time
period or someone is trying to upload too many images at once.
}
\examples{
\dontrun{
f = tempfile(fileext = ".png")
png(f)
plot(rnorm(100), main = R.version.string)
dev.off()

res = imgur_upload(f, include_xml = TRUE)
res  # link to original URL of the image
attr(res, "XML")  # all information
if (interactive())
    browseURL(res)

# to use your own key
options(xfun.upload_imgur.key = "your imgur key")
}
}
\references{
A demo: \url{https://yihui.org/knitr/demo/upload/}
}
\author{
Yihui Xie, adapted from the \pkg{imguR} package by Aaron Statham
}
