# Announce: Rakudo Perl 6 compiler, Release #99 (2016.05)

On behalf of the Rakudo development team, I’m very happy to announce the
May 2016 release of Rakudo Perl 6 #99. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to insure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, but please bear
with us post-Christmas. We are working hard to ensure that we don’t break
anything now that we have a released spec, and it make take us a few months
to settle back into a rhythm.

The changes in this release are outlined below:

New in 2016.05:
 + Fixes:
   + Fix EVAL during precompilation
   + .substr fixes
   + many precompilation fixes
   + clean up error messages
   + Streamline some core classes
   + Harden Mu.Str against moving GC
   + JVM fixes
   + Simplify `$*USER`/`$*GROUP` initialization
 + Additions:
   + Ability to use a customer debugger module
   + `$*MAIN-ALLOW-NAMED-ANYWHERE` allows MAIN to be friendlier about where it accepts flags
   + Add richer set of comparison operators for Versions
   + Many improvements to precompilation - building OS packages with precomp'd code should now be possible!
   + Introduce .Map coercer
   + Implement alternate ways to call subtest
 + Efficiency:
   + Version comparisons are now 2x faster
   + List.minmax is about 3.5x faster
   + Num.perl is about 2.4x faster
   + Int division/modulus is about 1.5x faster
   + LoL accesses are about 3x faster
   + autothreader is about 2-3x faster
   + Make Any junction methods 14x faster
   + Make Junctions faster
   + Map.kv is about 10% faster

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The following people contributed to this release:

Elizabeth Mattijsen, Pawel Murias, Jonathan Worthington, Stefan Seifert, Timo Paulssen, Pepe Schwarz, Bart Wiegmans, Jimmy Zhuo, Will "Coke" Coleda, Leon Timmermans, David Warring, Christian Bartolomäus, Daniel Green, tomboy64, Moritz Lenz, Altai-man, Rob Hoelz, Zoffix Znet, Salvador Ortiz, Tom Browder, Ahmad M. Zawawi, Xliff, Matt Oates, Nick Logan, Jonathan Stowe

as well as

Aleks-Daniel Jakimenko-Aleksejev, Brian Duggan, Brian S. Julin, Brock Wilcox, Christopher Bottoms, Clifton Wood, Coleoid, Dabrien 'Dabe' Murphy, Itsuki Toyota, Jan-Olof Hendig, Jason Cole, John Gabriele, Mathieu Gagnon, Philippe Bruhat (BooK), Siavash Askari Nasr, Sterling Hanenkamp, Steve Mynott, Tadeusz “tadzik” Sośnierz, VZ, Wenzel P. P. Peppmeyer, Will Coleda

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#100), is tentatively scheduled for 2016-06-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.
