---
title: "Uptobox"
description: "Rclone docs for Uptobox"
---

# {{< icon "fa fa-archive" >}} Uptobox

This is a Backend for Uptobox file storage service. Uptobox is closer to a one-click hoster than a traditional 
cloud storage provider and therefore not suitable for long term storage. 

Paths are specified as `remote:path`

Paths may be as deep as required, e.g. `remote:directory/subdirectory`.

## Configuration

To configure an Uptobox backend you'll need your personal api token. You'll find it in your
[account settings](https://uptobox.com/my_account)

Here is an example of how to make a remote called `remote` with the default setup.  First run:

    rclone config

This will guide you through an interactive setup process:

```
Current remotes:

Name                 Type
====                 ====
TestUptobox          uptobox

e) Edit existing remote
n) New remote
d) Delete remote
r) Rename remote
c) Copy remote
s) Set configuration password
q) Quit config
e/n/d/r/c/s/q> n
name> uptobox
Type of storage to configure.
Enter a string value. Press Enter for the default ("").
Choose a number from below, or type in your own value
[...]
37 / Uptobox
   \ "uptobox"
[...]
Storage> uptobox
** See help for uptobox backend at: https://rclone.org/uptobox/ **

Your API Key, get it from https://uptobox.com/my_account
Enter a string value. Press Enter for the default ("").
api_key> xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
Edit advanced config? (y/n)
y) Yes
n) No (default)
y/n> n
Remote config
--------------------
[uptobox]
type = uptobox
api_key = xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
--------------------
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> 
```
Once configured you can then use `rclone` like this,

List directories in top level of your Uptobox

    rclone lsd remote:

List all the files in your Uptobox

    rclone ls remote:

To copy a local directory to an Uptobox directory called backup

    rclone copy /home/source remote:backup

### Modified time and hashes

Uptobox supports neither modified times nor checksums.

### Restricted filename characters

In addition to the [default restricted characters set](/overview/#restricted-characters)
the following characters are also replaced:

| Character | Value | Replacement |
| --------- |:-----:|:-----------:|
| "         | 0x22  | ＂          |
| `         | 0x41  | ｀          |

Invalid UTF-8 bytes will also be [replaced](/overview/#invalid-utf8),
as they can't be used in XML strings.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/uptobox/uptobox.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to uptobox (Uptobox).

#### --uptobox-access-token

Your access token.

Get it from https://uptobox.com/my_account.

Properties:

- Config:      access_token
- Env Var:     RCLONE_UPTOBOX_ACCESS_TOKEN
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to uptobox (Uptobox).

#### --uptobox-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_UPTOBOX_ENCODING
- Type:        MultiEncoder
- Default:     Slash,LtGt,DoubleQuote,BackQuote,Del,Ctl,LeftSpace,InvalidUtf8,Dot

{{< rem autogenerated options stop >}}

## Limitations

Uptobox will delete inactive files that have not been accessed in 60 days.

`rclone about` is not supported by this backend an overview of used space can however
been seen in the uptobox web interface.
