// Copyright 2015 Google Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

//! CommonMark punctuation set based on spec and Unicode properties.

// Autogenerated by mk_puncttable.py

const PUNCT_MASKS_ASCII: [u16; 8] = [
    0x0000, // U+0000...U+000F
    0x0000, // U+0010...U+001F
    0xfffe, // U+0020...U+002F
    0xfc00, // U+0030...U+003F
    0x0001, // U+0040...U+004F
    0xf800, // U+0050...U+005F
    0x0001, // U+0060...U+006F
    0x7800, // U+0070...U+007F
];

const PUNCT_TAB: [u16; 727] = [
    10,   // U+00A0...U+00AF
    11,   // U+00B0...U+00BF
    13,   // U+00D0...U+00DF
    15,   // U+00F0...U+00FF
    44,   // U+02C0...U+02CF
    45,   // U+02D0...U+02DF
    46,   // U+02E0...U+02EF
    47,   // U+02F0...U+02FF
    55,   // U+0370...U+037F
    56,   // U+0380...U+038F
    63,   // U+03F0...U+03FF
    72,   // U+0480...U+048F
    85,   // U+0550...U+055F
    88,   // U+0580...U+058F
    91,   // U+05B0...U+05BF
    92,   // U+05C0...U+05CF
    95,   // U+05F0...U+05FF
    96,   // U+0600...U+060F
    97,   // U+0610...U+061F
    102,  // U+0660...U+066F
    109,  // U+06D0...U+06DF
    110,  // U+06E0...U+06EF
    111,  // U+06F0...U+06FF
    112,  // U+0700...U+070F
    127,  // U+07F0...U+07FF
    131,  // U+0830...U+083F
    133,  // U+0850...U+085F
    136,  // U+0880...U+088F
    150,  // U+0960...U+096F
    151,  // U+0970...U+097F
    159,  // U+09F0...U+09FF
    167,  // U+0A70...U+0A7F
    175,  // U+0AF0...U+0AFF
    183,  // U+0B70...U+0B7F
    191,  // U+0BF0...U+0BFF
    199,  // U+0C70...U+0C7F
    200,  // U+0C80...U+0C8F
    212,  // U+0D40...U+0D4F
    215,  // U+0D70...U+0D7F
    223,  // U+0DF0...U+0DFF
    227,  // U+0E30...U+0E3F
    228,  // U+0E40...U+0E4F
    229,  // U+0E50...U+0E5F
    240,  // U+0F00...U+0F0F
    241,  // U+0F10...U+0F1F
    243,  // U+0F30...U+0F3F
    248,  // U+0F80...U+0F8F
    251,  // U+0FB0...U+0FBF
    252,  // U+0FC0...U+0FCF
    253,  // U+0FD0...U+0FDF
    260,  // U+1040...U+104F
    265,  // U+1090...U+109F
    271,  // U+10F0...U+10FF
    310,  // U+1360...U+136F
    313,  // U+1390...U+139F
    320,  // U+1400...U+140F
    358,  // U+1660...U+166F
    361,  // U+1690...U+169F
    366,  // U+16E0...U+16EF
    371,  // U+1730...U+173F
    381,  // U+17D0...U+17DF
    384,  // U+1800...U+180F
    404,  // U+1940...U+194F
    413,  // U+19D0...U+19DF
    414,  // U+19E0...U+19EF
    415,  // U+19F0...U+19FF
    417,  // U+1A10...U+1A1F
    426,  // U+1AA0...U+1AAF
    437,  // U+1B50...U+1B5F
    438,  // U+1B60...U+1B6F
    439,  // U+1B70...U+1B7F
    447,  // U+1BF0...U+1BFF
    451,  // U+1C30...U+1C3F
    455,  // U+1C70...U+1C7F
    460,  // U+1CC0...U+1CCF
    461,  // U+1CD0...U+1CDF
    507,  // U+1FB0...U+1FBF
    508,  // U+1FC0...U+1FCF
    509,  // U+1FD0...U+1FDF
    510,  // U+1FE0...U+1FEF
    511,  // U+1FF0...U+1FFF
    513,  // U+2010...U+201F
    514,  // U+2020...U+202F
    515,  // U+2030...U+203F
    516,  // U+2040...U+204F
    517,  // U+2050...U+205F
    519,  // U+2070...U+207F
    520,  // U+2080...U+208F
    522,  // U+20A0...U+20AF
    523,  // U+20B0...U+20BF
    524,  // U+20C0...U+20CF
    528,  // U+2100...U+210F
    529,  // U+2110...U+211F
    530,  // U+2120...U+212F
    531,  // U+2130...U+213F
    532,  // U+2140...U+214F
    536,  // U+2180...U+218F
    537,  // U+2190...U+219F
    538,  // U+21A0...U+21AF
    539,  // U+21B0...U+21BF
    540,  // U+21C0...U+21CF
    541,  // U+21D0...U+21DF
    542,  // U+21E0...U+21EF
    543,  // U+21F0...U+21FF
    544,  // U+2200...U+220F
    545,  // U+2210...U+221F
    546,  // U+2220...U+222F
    547,  // U+2230...U+223F
    548,  // U+2240...U+224F
    549,  // U+2250...U+225F
    550,  // U+2260...U+226F
    551,  // U+2270...U+227F
    552,  // U+2280...U+228F
    553,  // U+2290...U+229F
    554,  // U+22A0...U+22AF
    555,  // U+22B0...U+22BF
    556,  // U+22C0...U+22CF
    557,  // U+22D0...U+22DF
    558,  // U+22E0...U+22EF
    559,  // U+22F0...U+22FF
    560,  // U+2300...U+230F
    561,  // U+2310...U+231F
    562,  // U+2320...U+232F
    563,  // U+2330...U+233F
    564,  // U+2340...U+234F
    565,  // U+2350...U+235F
    566,  // U+2360...U+236F
    567,  // U+2370...U+237F
    568,  // U+2380...U+238F
    569,  // U+2390...U+239F
    570,  // U+23A0...U+23AF
    571,  // U+23B0...U+23BF
    572,  // U+23C0...U+23CF
    573,  // U+23D0...U+23DF
    574,  // U+23E0...U+23EF
    575,  // U+23F0...U+23FF
    576,  // U+2400...U+240F
    577,  // U+2410...U+241F
    578,  // U+2420...U+242F
    580,  // U+2440...U+244F
    585,  // U+2490...U+249F
    586,  // U+24A0...U+24AF
    587,  // U+24B0...U+24BF
    588,  // U+24C0...U+24CF
    589,  // U+24D0...U+24DF
    590,  // U+24E0...U+24EF
    592,  // U+2500...U+250F
    593,  // U+2510...U+251F
    594,  // U+2520...U+252F
    595,  // U+2530...U+253F
    596,  // U+2540...U+254F
    597,  // U+2550...U+255F
    598,  // U+2560...U+256F
    599,  // U+2570...U+257F
    600,  // U+2580...U+258F
    601,  // U+2590...U+259F
    602,  // U+25A0...U+25AF
    603,  // U+25B0...U+25BF
    604,  // U+25C0...U+25CF
    605,  // U+25D0...U+25DF
    606,  // U+25E0...U+25EF
    607,  // U+25F0...U+25FF
    608,  // U+2600...U+260F
    609,  // U+2610...U+261F
    610,  // U+2620...U+262F
    611,  // U+2630...U+263F
    612,  // U+2640...U+264F
    613,  // U+2650...U+265F
    614,  // U+2660...U+266F
    615,  // U+2670...U+267F
    616,  // U+2680...U+268F
    617,  // U+2690...U+269F
    618,  // U+26A0...U+26AF
    619,  // U+26B0...U+26BF
    620,  // U+26C0...U+26CF
    621,  // U+26D0...U+26DF
    622,  // U+26E0...U+26EF
    623,  // U+26F0...U+26FF
    624,  // U+2700...U+270F
    625,  // U+2710...U+271F
    626,  // U+2720...U+272F
    627,  // U+2730...U+273F
    628,  // U+2740...U+274F
    629,  // U+2750...U+275F
    630,  // U+2760...U+276F
    631,  // U+2770...U+277F
    633,  // U+2790...U+279F
    634,  // U+27A0...U+27AF
    635,  // U+27B0...U+27BF
    636,  // U+27C0...U+27CF
    637,  // U+27D0...U+27DF
    638,  // U+27E0...U+27EF
    639,  // U+27F0...U+27FF
    640,  // U+2800...U+280F
    641,  // U+2810...U+281F
    642,  // U+2820...U+282F
    643,  // U+2830...U+283F
    644,  // U+2840...U+284F
    645,  // U+2850...U+285F
    646,  // U+2860...U+286F
    647,  // U+2870...U+287F
    648,  // U+2880...U+288F
    649,  // U+2890...U+289F
    650,  // U+28A0...U+28AF
    651,  // U+28B0...U+28BF
    652,  // U+28C0...U+28CF
    653,  // U+28D0...U+28DF
    654,  // U+28E0...U+28EF
    655,  // U+28F0...U+28FF
    656,  // U+2900...U+290F
    657,  // U+2910...U+291F
    658,  // U+2920...U+292F
    659,  // U+2930...U+293F
    660,  // U+2940...U+294F
    661,  // U+2950...U+295F
    662,  // U+2960...U+296F
    663,  // U+2970...U+297F
    664,  // U+2980...U+298F
    665,  // U+2990...U+299F
    666,  // U+29A0...U+29AF
    667,  // U+29B0...U+29BF
    668,  // U+29C0...U+29CF
    669,  // U+29D0...U+29DF
    670,  // U+29E0...U+29EF
    671,  // U+29F0...U+29FF
    672,  // U+2A00...U+2A0F
    673,  // U+2A10...U+2A1F
    674,  // U+2A20...U+2A2F
    675,  // U+2A30...U+2A3F
    676,  // U+2A40...U+2A4F
    677,  // U+2A50...U+2A5F
    678,  // U+2A60...U+2A6F
    679,  // U+2A70...U+2A7F
    680,  // U+2A80...U+2A8F
    681,  // U+2A90...U+2A9F
    682,  // U+2AA0...U+2AAF
    683,  // U+2AB0...U+2ABF
    684,  // U+2AC0...U+2ACF
    685,  // U+2AD0...U+2ADF
    686,  // U+2AE0...U+2AEF
    687,  // U+2AF0...U+2AFF
    688,  // U+2B00...U+2B0F
    689,  // U+2B10...U+2B1F
    690,  // U+2B20...U+2B2F
    691,  // U+2B30...U+2B3F
    692,  // U+2B40...U+2B4F
    693,  // U+2B50...U+2B5F
    694,  // U+2B60...U+2B6F
    695,  // U+2B70...U+2B7F
    696,  // U+2B80...U+2B8F
    697,  // U+2B90...U+2B9F
    698,  // U+2BA0...U+2BAF
    699,  // U+2BB0...U+2BBF
    700,  // U+2BC0...U+2BCF
    701,  // U+2BD0...U+2BDF
    702,  // U+2BE0...U+2BEF
    703,  // U+2BF0...U+2BFF
    718,  // U+2CE0...U+2CEF
    719,  // U+2CF0...U+2CFF
    727,  // U+2D70...U+2D7F
    736,  // U+2E00...U+2E0F
    737,  // U+2E10...U+2E1F
    738,  // U+2E20...U+2E2F
    739,  // U+2E30...U+2E3F
    740,  // U+2E40...U+2E4F
    741,  // U+2E50...U+2E5F
    744,  // U+2E80...U+2E8F
    745,  // U+2E90...U+2E9F
    746,  // U+2EA0...U+2EAF
    747,  // U+2EB0...U+2EBF
    748,  // U+2EC0...U+2ECF
    749,  // U+2ED0...U+2EDF
    750,  // U+2EE0...U+2EEF
    751,  // U+2EF0...U+2EFF
    752,  // U+2F00...U+2F0F
    753,  // U+2F10...U+2F1F
    754,  // U+2F20...U+2F2F
    755,  // U+2F30...U+2F3F
    756,  // U+2F40...U+2F4F
    757,  // U+2F50...U+2F5F
    758,  // U+2F60...U+2F6F
    759,  // U+2F70...U+2F7F
    760,  // U+2F80...U+2F8F
    761,  // U+2F90...U+2F9F
    762,  // U+2FA0...U+2FAF
    763,  // U+2FB0...U+2FBF
    764,  // U+2FC0...U+2FCF
    765,  // U+2FD0...U+2FDF
    767,  // U+2FF0...U+2FFF
    768,  // U+3000...U+300F
    769,  // U+3010...U+301F
    770,  // U+3020...U+302F
    771,  // U+3030...U+303F
    777,  // U+3090...U+309F
    778,  // U+30A0...U+30AF
    783,  // U+30F0...U+30FF
    793,  // U+3190...U+319F
    796,  // U+31C0...U+31CF
    797,  // U+31D0...U+31DF
    798,  // U+31E0...U+31EF
    800,  // U+3200...U+320F
    801,  // U+3210...U+321F
    802,  // U+3220...U+322F
    803,  // U+3230...U+323F
    804,  // U+3240...U+324F
    805,  // U+3250...U+325F
    806,  // U+3260...U+326F
    807,  // U+3270...U+327F
    808,  // U+3280...U+328F
    809,  // U+3290...U+329F
    810,  // U+32A0...U+32AF
    811,  // U+32B0...U+32BF
    812,  // U+32C0...U+32CF
    813,  // U+32D0...U+32DF
    814,  // U+32E0...U+32EF
    815,  // U+32F0...U+32FF
    816,  // U+3300...U+330F
    817,  // U+3310...U+331F
    818,  // U+3320...U+332F
    819,  // U+3330...U+333F
    820,  // U+3340...U+334F
    821,  // U+3350...U+335F
    822,  // U+3360...U+336F
    823,  // U+3370...U+337F
    824,  // U+3380...U+338F
    825,  // U+3390...U+339F
    826,  // U+33A0...U+33AF
    827,  // U+33B0...U+33BF
    828,  // U+33C0...U+33CF
    829,  // U+33D0...U+33DF
    830,  // U+33E0...U+33EF
    831,  // U+33F0...U+33FF
    1244, // U+4DC0...U+4DCF
    1245, // U+4DD0...U+4DDF
    1246, // U+4DE0...U+4DEF
    1247, // U+4DF0...U+4DFF
    2633, // U+A490...U+A49F
    2634, // U+A4A0...U+A4AF
    2635, // U+A4B0...U+A4BF
    2636, // U+A4C0...U+A4CF
    2639, // U+A4F0...U+A4FF
    2656, // U+A600...U+A60F
    2663, // U+A670...U+A67F
    2671, // U+A6F0...U+A6FF
    2672, // U+A700...U+A70F
    2673, // U+A710...U+A71F
    2674, // U+A720...U+A72F
    2680, // U+A780...U+A78F
    2690, // U+A820...U+A82F
    2691, // U+A830...U+A83F
    2695, // U+A870...U+A87F
    2700, // U+A8C0...U+A8CF
    2703, // U+A8F0...U+A8FF
    2706, // U+A920...U+A92F
    2709, // U+A950...U+A95F
    2716, // U+A9C0...U+A9CF
    2717, // U+A9D0...U+A9DF
    2725, // U+AA50...U+AA5F
    2727, // U+AA70...U+AA7F
    2733, // U+AAD0...U+AADF
    2735, // U+AAF0...U+AAFF
    2741, // U+AB50...U+AB5F
    2742, // U+AB60...U+AB6F
    2750, // U+ABE0...U+ABEF
    4018, // U+FB20...U+FB2F
    4027, // U+FBB0...U+FBBF
    4028, // U+FBC0...U+FBCF
    4051, // U+FD30...U+FD3F
    4052, // U+FD40...U+FD4F
    4060, // U+FDC0...U+FDCF
    4063, // U+FDF0...U+FDFF
    4065, // U+FE10...U+FE1F
    4067, // U+FE30...U+FE3F
    4068, // U+FE40...U+FE4F
    4069, // U+FE50...U+FE5F
    4070, // U+FE60...U+FE6F
    4080, // U+FF00...U+FF0F
    4081, // U+FF10...U+FF1F
    4082, // U+FF20...U+FF2F
    4083, // U+FF30...U+FF3F
    4084, // U+FF40...U+FF4F
    4085, // U+FF50...U+FF5F
    4086, // U+FF60...U+FF6F
    4094, // U+FFE0...U+FFEF
    4095, // U+FFF0...U+FFFF
    4112, // U+10100...U+1010F
    4115, // U+10130...U+1013F
    4119, // U+10170...U+1017F
    4120, // U+10180...U+1018F
    4121, // U+10190...U+1019F
    4122, // U+101A0...U+101AF
    4125, // U+101D0...U+101DF
    4126, // U+101E0...U+101EF
    4127, // U+101F0...U+101FF
    4153, // U+10390...U+1039F
    4157, // U+103D0...U+103DF
    4182, // U+10560...U+1056F
    4229, // U+10850...U+1085F
    4231, // U+10870...U+1087F
    4241, // U+10910...U+1091F
    4243, // U+10930...U+1093F
    4261, // U+10A50...U+10A5F
    4263, // U+10A70...U+10A7F
    4268, // U+10AC0...U+10ACF
    4271, // U+10AF0...U+10AFF
    4275, // U+10B30...U+10B3F
    4281, // U+10B90...U+10B9F
    4330, // U+10EA0...U+10EAF
    4341, // U+10F50...U+10F5F
    4344, // U+10F80...U+10F8F
    4356, // U+11040...U+1104F
    4363, // U+110B0...U+110BF
    4364, // U+110C0...U+110CF
    4372, // U+11140...U+1114F
    4375, // U+11170...U+1117F
    4380, // U+111C0...U+111CF
    4381, // U+111D0...U+111DF
    4387, // U+11230...U+1123F
    4394, // U+112A0...U+112AF
    4420, // U+11440...U+1144F
    4421, // U+11450...U+1145F
    4428, // U+114C0...U+114CF
    4444, // U+115C0...U+115CF
    4445, // U+115D0...U+115DF
    4452, // U+11640...U+1164F
    4454, // U+11660...U+1166F
    4459, // U+116B0...U+116BF
    4467, // U+11730...U+1173F
    4483, // U+11830...U+1183F
    4500, // U+11940...U+1194F
    4510, // U+119E0...U+119EF
    4515, // U+11A30...U+11A3F
    4516, // U+11A40...U+11A4F
    4521, // U+11A90...U+11A9F
    4522, // U+11AA0...U+11AAF
    4528, // U+11B00...U+11B0F
    4548, // U+11C40...U+11C4F
    4551, // U+11C70...U+11C7F
    4591, // U+11EF0...U+11EFF
    4596, // U+11F40...U+11F4F
    4605, // U+11FD0...U+11FDF
    4606, // U+11FE0...U+11FEF
    4607, // U+11FF0...U+11FFF
    4679, // U+12470...U+1247F
    4863, // U+12FF0...U+12FFF
    5798, // U+16A60...U+16A6F
    5807, // U+16AF0...U+16AFF
    5811, // U+16B30...U+16B3F
    5812, // U+16B40...U+16B4F
    5865, // U+16E90...U+16E9F
    5886, // U+16FE0...U+16FEF
    7113, // U+1BC90...U+1BC9F
    7413, // U+1CF50...U+1CF5F
    7414, // U+1CF60...U+1CF6F
    7415, // U+1CF70...U+1CF7F
    7416, // U+1CF80...U+1CF8F
    7417, // U+1CF90...U+1CF9F
    7418, // U+1CFA0...U+1CFAF
    7419, // U+1CFB0...U+1CFBF
    7420, // U+1CFC0...U+1CFCF
    7424, // U+1D000...U+1D00F
    7425, // U+1D010...U+1D01F
    7426, // U+1D020...U+1D02F
    7427, // U+1D030...U+1D03F
    7428, // U+1D040...U+1D04F
    7429, // U+1D050...U+1D05F
    7430, // U+1D060...U+1D06F
    7431, // U+1D070...U+1D07F
    7432, // U+1D080...U+1D08F
    7433, // U+1D090...U+1D09F
    7434, // U+1D0A0...U+1D0AF
    7435, // U+1D0B0...U+1D0BF
    7436, // U+1D0C0...U+1D0CF
    7437, // U+1D0D0...U+1D0DF
    7438, // U+1D0E0...U+1D0EF
    7439, // U+1D0F0...U+1D0FF
    7440, // U+1D100...U+1D10F
    7441, // U+1D110...U+1D11F
    7442, // U+1D120...U+1D12F
    7443, // U+1D130...U+1D13F
    7444, // U+1D140...U+1D14F
    7445, // U+1D150...U+1D15F
    7446, // U+1D160...U+1D16F
    7448, // U+1D180...U+1D18F
    7449, // U+1D190...U+1D19F
    7450, // U+1D1A0...U+1D1AF
    7451, // U+1D1B0...U+1D1BF
    7452, // U+1D1C0...U+1D1CF
    7453, // U+1D1D0...U+1D1DF
    7454, // U+1D1E0...U+1D1EF
    7456, // U+1D200...U+1D20F
    7457, // U+1D210...U+1D21F
    7458, // U+1D220...U+1D22F
    7459, // U+1D230...U+1D23F
    7460, // U+1D240...U+1D24F
    7472, // U+1D300...U+1D30F
    7473, // U+1D310...U+1D31F
    7474, // U+1D320...U+1D32F
    7475, // U+1D330...U+1D33F
    7476, // U+1D340...U+1D34F
    7477, // U+1D350...U+1D35F
    7532, // U+1D6C0...U+1D6CF
    7533, // U+1D6D0...U+1D6DF
    7535, // U+1D6F0...U+1D6FF
    7537, // U+1D710...U+1D71F
    7539, // U+1D730...U+1D73F
    7540, // U+1D740...U+1D74F
    7542, // U+1D760...U+1D76F
    7544, // U+1D780...U+1D78F
    7546, // U+1D7A0...U+1D7AF
    7548, // U+1D7C0...U+1D7CF
    7552, // U+1D800...U+1D80F
    7553, // U+1D810...U+1D81F
    7554, // U+1D820...U+1D82F
    7555, // U+1D830...U+1D83F
    7556, // U+1D840...U+1D84F
    7557, // U+1D850...U+1D85F
    7558, // U+1D860...U+1D86F
    7559, // U+1D870...U+1D87F
    7560, // U+1D880...U+1D88F
    7561, // U+1D890...U+1D89F
    7562, // U+1D8A0...U+1D8AF
    7563, // U+1D8B0...U+1D8BF
    7564, // U+1D8C0...U+1D8CF
    7565, // U+1D8D0...U+1D8DF
    7566, // U+1D8E0...U+1D8EF
    7567, // U+1D8F0...U+1D8FF
    7568, // U+1D900...U+1D90F
    7569, // U+1D910...U+1D91F
    7570, // U+1D920...U+1D92F
    7571, // U+1D930...U+1D93F
    7572, // U+1D940...U+1D94F
    7573, // U+1D950...U+1D95F
    7574, // U+1D960...U+1D96F
    7575, // U+1D970...U+1D97F
    7576, // U+1D980...U+1D98F
    7577, // U+1D990...U+1D99F
    7578, // U+1D9A0...U+1D9AF
    7579, // U+1D9B0...U+1D9BF
    7580, // U+1D9C0...U+1D9CF
    7581, // U+1D9D0...U+1D9DF
    7582, // U+1D9E0...U+1D9EF
    7583, // U+1D9F0...U+1D9FF
    7587, // U+1DA30...U+1DA3F
    7590, // U+1DA60...U+1DA6F
    7591, // U+1DA70...U+1DA7F
    7592, // U+1DA80...U+1DA8F
    7700, // U+1E140...U+1E14F
    7727, // U+1E2F0...U+1E2FF
    7829, // U+1E950...U+1E95F
    7882, // U+1ECA0...U+1ECAF
    7883, // U+1ECB0...U+1ECBF
    7890, // U+1ED20...U+1ED2F
    7919, // U+1EEF0...U+1EEFF
    7936, // U+1F000...U+1F00F
    7937, // U+1F010...U+1F01F
    7938, // U+1F020...U+1F02F
    7939, // U+1F030...U+1F03F
    7940, // U+1F040...U+1F04F
    7941, // U+1F050...U+1F05F
    7942, // U+1F060...U+1F06F
    7943, // U+1F070...U+1F07F
    7944, // U+1F080...U+1F08F
    7945, // U+1F090...U+1F09F
    7946, // U+1F0A0...U+1F0AF
    7947, // U+1F0B0...U+1F0BF
    7948, // U+1F0C0...U+1F0CF
    7949, // U+1F0D0...U+1F0DF
    7950, // U+1F0E0...U+1F0EF
    7951, // U+1F0F0...U+1F0FF
    7952, // U+1F100...U+1F10F
    7953, // U+1F110...U+1F11F
    7954, // U+1F120...U+1F12F
    7955, // U+1F130...U+1F13F
    7956, // U+1F140...U+1F14F
    7957, // U+1F150...U+1F15F
    7958, // U+1F160...U+1F16F
    7959, // U+1F170...U+1F17F
    7960, // U+1F180...U+1F18F
    7961, // U+1F190...U+1F19F
    7962, // U+1F1A0...U+1F1AF
    7966, // U+1F1E0...U+1F1EF
    7967, // U+1F1F0...U+1F1FF
    7968, // U+1F200...U+1F20F
    7969, // U+1F210...U+1F21F
    7970, // U+1F220...U+1F22F
    7971, // U+1F230...U+1F23F
    7972, // U+1F240...U+1F24F
    7973, // U+1F250...U+1F25F
    7974, // U+1F260...U+1F26F
    7984, // U+1F300...U+1F30F
    7985, // U+1F310...U+1F31F
    7986, // U+1F320...U+1F32F
    7987, // U+1F330...U+1F33F
    7988, // U+1F340...U+1F34F
    7989, // U+1F350...U+1F35F
    7990, // U+1F360...U+1F36F
    7991, // U+1F370...U+1F37F
    7992, // U+1F380...U+1F38F
    7993, // U+1F390...U+1F39F
    7994, // U+1F3A0...U+1F3AF
    7995, // U+1F3B0...U+1F3BF
    7996, // U+1F3C0...U+1F3CF
    7997, // U+1F3D0...U+1F3DF
    7998, // U+1F3E0...U+1F3EF
    7999, // U+1F3F0...U+1F3FF
    8000, // U+1F400...U+1F40F
    8001, // U+1F410...U+1F41F
    8002, // U+1F420...U+1F42F
    8003, // U+1F430...U+1F43F
    8004, // U+1F440...U+1F44F
    8005, // U+1F450...U+1F45F
    8006, // U+1F460...U+1F46F
    8007, // U+1F470...U+1F47F
    8008, // U+1F480...U+1F48F
    8009, // U+1F490...U+1F49F
    8010, // U+1F4A0...U+1F4AF
    8011, // U+1F4B0...U+1F4BF
    8012, // U+1F4C0...U+1F4CF
    8013, // U+1F4D0...U+1F4DF
    8014, // U+1F4E0...U+1F4EF
    8015, // U+1F4F0...U+1F4FF
    8016, // U+1F500...U+1F50F
    8017, // U+1F510...U+1F51F
    8018, // U+1F520...U+1F52F
    8019, // U+1F530...U+1F53F
    8020, // U+1F540...U+1F54F
    8021, // U+1F550...U+1F55F
    8022, // U+1F560...U+1F56F
    8023, // U+1F570...U+1F57F
    8024, // U+1F580...U+1F58F
    8025, // U+1F590...U+1F59F
    8026, // U+1F5A0...U+1F5AF
    8027, // U+1F5B0...U+1F5BF
    8028, // U+1F5C0...U+1F5CF
    8029, // U+1F5D0...U+1F5DF
    8030, // U+1F5E0...U+1F5EF
    8031, // U+1F5F0...U+1F5FF
    8032, // U+1F600...U+1F60F
    8033, // U+1F610...U+1F61F
    8034, // U+1F620...U+1F62F
    8035, // U+1F630...U+1F63F
    8036, // U+1F640...U+1F64F
    8037, // U+1F650...U+1F65F
    8038, // U+1F660...U+1F66F
    8039, // U+1F670...U+1F67F
    8040, // U+1F680...U+1F68F
    8041, // U+1F690...U+1F69F
    8042, // U+1F6A0...U+1F6AF
    8043, // U+1F6B0...U+1F6BF
    8044, // U+1F6C0...U+1F6CF
    8045, // U+1F6D0...U+1F6DF
    8046, // U+1F6E0...U+1F6EF
    8047, // U+1F6F0...U+1F6FF
    8048, // U+1F700...U+1F70F
    8049, // U+1F710...U+1F71F
    8050, // U+1F720...U+1F72F
    8051, // U+1F730...U+1F73F
    8052, // U+1F740...U+1F74F
    8053, // U+1F750...U+1F75F
    8054, // U+1F760...U+1F76F
    8055, // U+1F770...U+1F77F
    8056, // U+1F780...U+1F78F
    8057, // U+1F790...U+1F79F
    8058, // U+1F7A0...U+1F7AF
    8059, // U+1F7B0...U+1F7BF
    8060, // U+1F7C0...U+1F7CF
    8061, // U+1F7D0...U+1F7DF
    8062, // U+1F7E0...U+1F7EF
    8063, // U+1F7F0...U+1F7FF
    8064, // U+1F800...U+1F80F
    8065, // U+1F810...U+1F81F
    8066, // U+1F820...U+1F82F
    8067, // U+1F830...U+1F83F
    8068, // U+1F840...U+1F84F
    8069, // U+1F850...U+1F85F
    8070, // U+1F860...U+1F86F
    8071, // U+1F870...U+1F87F
    8072, // U+1F880...U+1F88F
    8073, // U+1F890...U+1F89F
    8074, // U+1F8A0...U+1F8AF
    8075, // U+1F8B0...U+1F8BF
    8080, // U+1F900...U+1F90F
    8081, // U+1F910...U+1F91F
    8082, // U+1F920...U+1F92F
    8083, // U+1F930...U+1F93F
    8084, // U+1F940...U+1F94F
    8085, // U+1F950...U+1F95F
    8086, // U+1F960...U+1F96F
    8087, // U+1F970...U+1F97F
    8088, // U+1F980...U+1F98F
    8089, // U+1F990...U+1F99F
    8090, // U+1F9A0...U+1F9AF
    8091, // U+1F9B0...U+1F9BF
    8092, // U+1F9C0...U+1F9CF
    8093, // U+1F9D0...U+1F9DF
    8094, // U+1F9E0...U+1F9EF
    8095, // U+1F9F0...U+1F9FF
    8096, // U+1FA00...U+1FA0F
    8097, // U+1FA10...U+1FA1F
    8098, // U+1FA20...U+1FA2F
    8099, // U+1FA30...U+1FA3F
    8100, // U+1FA40...U+1FA4F
    8101, // U+1FA50...U+1FA5F
    8102, // U+1FA60...U+1FA6F
    8103, // U+1FA70...U+1FA7F
    8104, // U+1FA80...U+1FA8F
    8105, // U+1FA90...U+1FA9F
    8106, // U+1FAA0...U+1FAAF
    8107, // U+1FAB0...U+1FABF
    8108, // U+1FAC0...U+1FACF
    8109, // U+1FAD0...U+1FADF
    8110, // U+1FAE0...U+1FAEF
    8111, // U+1FAF0...U+1FAFF
    8112, // U+1FB00...U+1FB0F
    8113, // U+1FB10...U+1FB1F
    8114, // U+1FB20...U+1FB2F
    8115, // U+1FB30...U+1FB3F
    8116, // U+1FB40...U+1FB4F
    8117, // U+1FB50...U+1FB5F
    8118, // U+1FB60...U+1FB6F
    8119, // U+1FB70...U+1FB7F
    8120, // U+1FB80...U+1FB8F
    8121, // U+1FB90...U+1FB9F
    8122, // U+1FBA0...U+1FBAF
    8123, // U+1FBB0...U+1FBBF
    8124, // U+1FBC0...U+1FBCF
];

const PUNCT_MASKS: [u16; 727] = [
    0xdbfe, // U+00A0...U+00AF
    0x89d3, // U+00B0...U+00BF
    0x0080, // U+00D0...U+00DF
    0x0080, // U+00F0...U+00FF
    0x003c, // U+02C0...U+02CF
    0xfffc, // U+02D0...U+02DF
    0xafe0, // U+02E0...U+02EF
    0xffff, // U+02F0...U+02FF
    0x4020, // U+0370...U+037F
    0x00b0, // U+0380...U+038F
    0x0040, // U+03F0...U+03FF
    0x0004, // U+0480...U+048F
    0xfc00, // U+0550...U+055F
    0xe600, // U+0580...U+058F
    0x4000, // U+05B0...U+05BF
    0x0049, // U+05C0...U+05CF
    0x0018, // U+05F0...U+05FF
    0xffc0, // U+0600...U+060F
    0xe800, // U+0610...U+061F
    0x3c00, // U+0660...U+066F
    0x4010, // U+06D0...U+06DF
    0x0200, // U+06E0...U+06EF
    0x6000, // U+06F0...U+06FF
    0x3fff, // U+0700...U+070F
    0xc3c0, // U+07F0...U+07FF
    0x7fff, // U+0830...U+083F
    0x4000, // U+0850...U+085F
    0x0100, // U+0880...U+088F
    0x0030, // U+0960...U+096F
    0x0001, // U+0970...U+097F
    0x2c0c, // U+09F0...U+09FF
    0x0040, // U+0A70...U+0A7F
    0x0003, // U+0AF0...U+0AFF
    0x0001, // U+0B70...U+0B7F
    0x07f8, // U+0BF0...U+0BFF
    0x8080, // U+0C70...U+0C7F
    0x0010, // U+0C80...U+0C8F
    0x8000, // U+0D40...U+0D4F
    0x0200, // U+0D70...U+0D7F
    0x0010, // U+0DF0...U+0DFF
    0x8000, // U+0E30...U+0E3F
    0x8000, // U+0E40...U+0E4F
    0x0c00, // U+0E50...U+0E5F
    0xfffe, // U+0F00...U+0F0F
    0xfcff, // U+0F10...U+0F1F
    0x3d50, // U+0F30...U+0F3F
    0x0020, // U+0F80...U+0F8F
    0xc000, // U+0FB0...U+0FBF
    0xdfbf, // U+0FC0...U+0FCF
    0x07ff, // U+0FD0...U+0FDF
    0xfc00, // U+1040...U+104F
    0xc000, // U+1090...U+109F
    0x0800, // U+10F0...U+10FF
    0x01ff, // U+1360...U+136F
    0x03ff, // U+1390...U+139F
    0x0001, // U+1400...U+140F
    0x6000, // U+1660...U+166F
    0x1800, // U+1690...U+169F
    0x3800, // U+16E0...U+16EF
    0x0060, // U+1730...U+173F
    0x0f70, // U+17D0...U+17DF
    0x07ff, // U+1800...U+180F
    0x0031, // U+1940...U+194F
    0xc000, // U+19D0...U+19DF
    0xffff, // U+19E0...U+19EF
    0xffff, // U+19F0...U+19FF
    0xc000, // U+1A10...U+1A1F
    0x3f7f, // U+1AA0...U+1AAF
    0xfc00, // U+1B50...U+1B5F
    0x07ff, // U+1B60...U+1B6F
    0x7ff0, // U+1B70...U+1B7F
    0xf000, // U+1BF0...U+1BFF
    0xf800, // U+1C30...U+1C3F
    0xc000, // U+1C70...U+1C7F
    0x00ff, // U+1CC0...U+1CCF
    0x0008, // U+1CD0...U+1CDF
    0xa000, // U+1FB0...U+1FBF
    0xe003, // U+1FC0...U+1FCF
    0xe000, // U+1FD0...U+1FDF
    0xe000, // U+1FE0...U+1FEF
    0x6000, // U+1FF0...U+1FFF
    0xffff, // U+2010...U+201F
    0x00ff, // U+2020...U+202F
    0xffff, // U+2030...U+203F
    0xffff, // U+2040...U+204F
    0x7fff, // U+2050...U+205F
    0x7c00, // U+2070...U+207F
    0x7c00, // U+2080...U+208F
    0xffff, // U+20A0...U+20AF
    0xffff, // U+20B0...U+20BF
    0x0001, // U+20C0...U+20CF
    0x037b, // U+2100...U+210F
    0xc1d0, // U+2110...U+211F
    0x42af, // U+2120...U+212F
    0x0c00, // U+2130...U+213F
    0xbc1f, // U+2140...U+214F
    0x0c00, // U+2180...U+218F
    0xffff, // U+2190...U+219F
    0xffff, // U+21A0...U+21AF
    0xffff, // U+21B0...U+21BF
    0xffff, // U+21C0...U+21CF
    0xffff, // U+21D0...U+21DF
    0xffff, // U+21E0...U+21EF
    0xffff, // U+21F0...U+21FF
    0xffff, // U+2200...U+220F
    0xffff, // U+2210...U+221F
    0xffff, // U+2220...U+222F
    0xffff, // U+2230...U+223F
    0xffff, // U+2240...U+224F
    0xffff, // U+2250...U+225F
    0xffff, // U+2260...U+226F
    0xffff, // U+2270...U+227F
    0xffff, // U+2280...U+228F
    0xffff, // U+2290...U+229F
    0xffff, // U+22A0...U+22AF
    0xffff, // U+22B0...U+22BF
    0xffff, // U+22C0...U+22CF
    0xffff, // U+22D0...U+22DF
    0xffff, // U+22E0...U+22EF
    0xffff, // U+22F0...U+22FF
    0xffff, // U+2300...U+230F
    0xffff, // U+2310...U+231F
    0xffff, // U+2320...U+232F
    0xffff, // U+2330...U+233F
    0xffff, // U+2340...U+234F
    0xffff, // U+2350...U+235F
    0xffff, // U+2360...U+236F
    0xffff, // U+2370...U+237F
    0xffff, // U+2380...U+238F
    0xffff, // U+2390...U+239F
    0xffff, // U+23A0...U+23AF
    0xffff, // U+23B0...U+23BF
    0xffff, // U+23C0...U+23CF
    0xffff, // U+23D0...U+23DF
    0xffff, // U+23E0...U+23EF
    0xffff, // U+23F0...U+23FF
    0xffff, // U+2400...U+240F
    0xffff, // U+2410...U+241F
    0x007f, // U+2420...U+242F
    0x07ff, // U+2440...U+244F
    0xf000, // U+2490...U+249F
    0xffff, // U+24A0...U+24AF
    0xffff, // U+24B0...U+24BF
    0xffff, // U+24C0...U+24CF
    0xffff, // U+24D0...U+24DF
    0x03ff, // U+24E0...U+24EF
    0xffff, // U+2500...U+250F
    0xffff, // U+2510...U+251F
    0xffff, // U+2520...U+252F
    0xffff, // U+2530...U+253F
    0xffff, // U+2540...U+254F
    0xffff, // U+2550...U+255F
    0xffff, // U+2560...U+256F
    0xffff, // U+2570...U+257F
    0xffff, // U+2580...U+258F
    0xffff, // U+2590...U+259F
    0xffff, // U+25A0...U+25AF
    0xffff, // U+25B0...U+25BF
    0xffff, // U+25C0...U+25CF
    0xffff, // U+25D0...U+25DF
    0xffff, // U+25E0...U+25EF
    0xffff, // U+25F0...U+25FF
    0xffff, // U+2600...U+260F
    0xffff, // U+2610...U+261F
    0xffff, // U+2620...U+262F
    0xffff, // U+2630...U+263F
    0xffff, // U+2640...U+264F
    0xffff, // U+2650...U+265F
    0xffff, // U+2660...U+266F
    0xffff, // U+2670...U+267F
    0xffff, // U+2680...U+268F
    0xffff, // U+2690...U+269F
    0xffff, // U+26A0...U+26AF
    0xffff, // U+26B0...U+26BF
    0xffff, // U+26C0...U+26CF
    0xffff, // U+26D0...U+26DF
    0xffff, // U+26E0...U+26EF
    0xffff, // U+26F0...U+26FF
    0xffff, // U+2700...U+270F
    0xffff, // U+2710...U+271F
    0xffff, // U+2720...U+272F
    0xffff, // U+2730...U+273F
    0xffff, // U+2740...U+274F
    0xffff, // U+2750...U+275F
    0xffff, // U+2760...U+276F
    0x003f, // U+2770...U+277F
    0xfff0, // U+2790...U+279F
    0xffff, // U+27A0...U+27AF
    0xffff, // U+27B0...U+27BF
    0xffff, // U+27C0...U+27CF
    0xffff, // U+27D0...U+27DF
    0xffff, // U+27E0...U+27EF
    0xffff, // U+27F0...U+27FF
    0xffff, // U+2800...U+280F
    0xffff, // U+2810...U+281F
    0xffff, // U+2820...U+282F
    0xffff, // U+2830...U+283F
    0xffff, // U+2840...U+284F
    0xffff, // U+2850...U+285F
    0xffff, // U+2860...U+286F
    0xffff, // U+2870...U+287F
    0xffff, // U+2880...U+288F
    0xffff, // U+2890...U+289F
    0xffff, // U+28A0...U+28AF
    0xffff, // U+28B0...U+28BF
    0xffff, // U+28C0...U+28CF
    0xffff, // U+28D0...U+28DF
    0xffff, // U+28E0...U+28EF
    0xffff, // U+28F0...U+28FF
    0xffff, // U+2900...U+290F
    0xffff, // U+2910...U+291F
    0xffff, // U+2920...U+292F
    0xffff, // U+2930...U+293F
    0xffff, // U+2940...U+294F
    0xffff, // U+2950...U+295F
    0xffff, // U+2960...U+296F
    0xffff, // U+2970...U+297F
    0xffff, // U+2980...U+298F
    0xffff, // U+2990...U+299F
    0xffff, // U+29A0...U+29AF
    0xffff, // U+29B0...U+29BF
    0xffff, // U+29C0...U+29CF
    0xffff, // U+29D0...U+29DF
    0xffff, // U+29E0...U+29EF
    0xffff, // U+29F0...U+29FF
    0xffff, // U+2A00...U+2A0F
    0xffff, // U+2A10...U+2A1F
    0xffff, // U+2A20...U+2A2F
    0xffff, // U+2A30...U+2A3F
    0xffff, // U+2A40...U+2A4F
    0xffff, // U+2A50...U+2A5F
    0xffff, // U+2A60...U+2A6F
    0xffff, // U+2A70...U+2A7F
    0xffff, // U+2A80...U+2A8F
    0xffff, // U+2A90...U+2A9F
    0xffff, // U+2AA0...U+2AAF
    0xffff, // U+2AB0...U+2ABF
    0xffff, // U+2AC0...U+2ACF
    0xffff, // U+2AD0...U+2ADF
    0xffff, // U+2AE0...U+2AEF
    0xffff, // U+2AF0...U+2AFF
    0xffff, // U+2B00...U+2B0F
    0xffff, // U+2B10...U+2B1F
    0xffff, // U+2B20...U+2B2F
    0xffff, // U+2B30...U+2B3F
    0xffff, // U+2B40...U+2B4F
    0xffff, // U+2B50...U+2B5F
    0xffff, // U+2B60...U+2B6F
    0xffcf, // U+2B70...U+2B7F
    0xffff, // U+2B80...U+2B8F
    0xffbf, // U+2B90...U+2B9F
    0xffff, // U+2BA0...U+2BAF
    0xffff, // U+2BB0...U+2BBF
    0xffff, // U+2BC0...U+2BCF
    0xffff, // U+2BD0...U+2BDF
    0xffff, // U+2BE0...U+2BEF
    0xffff, // U+2BF0...U+2BFF
    0x07e0, // U+2CE0...U+2CEF
    0xde00, // U+2CF0...U+2CFF
    0x0001, // U+2D70...U+2D7F
    0xffff, // U+2E00...U+2E0F
    0xffff, // U+2E10...U+2E1F
    0x7fff, // U+2E20...U+2E2F
    0xffff, // U+2E30...U+2E3F
    0xffff, // U+2E40...U+2E4F
    0x3fff, // U+2E50...U+2E5F
    0xffff, // U+2E80...U+2E8F
    0xfbff, // U+2E90...U+2E9F
    0xffff, // U+2EA0...U+2EAF
    0xffff, // U+2EB0...U+2EBF
    0xffff, // U+2EC0...U+2ECF
    0xffff, // U+2ED0...U+2EDF
    0xffff, // U+2EE0...U+2EEF
    0x000f, // U+2EF0...U+2EFF
    0xffff, // U+2F00...U+2F0F
    0xffff, // U+2F10...U+2F1F
    0xffff, // U+2F20...U+2F2F
    0xffff, // U+2F30...U+2F3F
    0xffff, // U+2F40...U+2F4F
    0xffff, // U+2F50...U+2F5F
    0xffff, // U+2F60...U+2F6F
    0xffff, // U+2F70...U+2F7F
    0xffff, // U+2F80...U+2F8F
    0xffff, // U+2F90...U+2F9F
    0xffff, // U+2FA0...U+2FAF
    0xffff, // U+2FB0...U+2FBF
    0xffff, // U+2FC0...U+2FCF
    0x003f, // U+2FD0...U+2FDF
    0xffff, // U+2FF0...U+2FFF
    0xff1e, // U+3000...U+300F
    0xffff, // U+3010...U+301F
    0x0001, // U+3020...U+302F
    0xe0c1, // U+3030...U+303F
    0x1800, // U+3090...U+309F
    0x0001, // U+30A0...U+30AF
    0x0800, // U+30F0...U+30FF
    0xffc3, // U+3190...U+319F
    0xffff, // U+31C0...U+31CF
    0xffff, // U+31D0...U+31DF
    0x800f, // U+31E0...U+31EF
    0xffff, // U+3200...U+320F
    0x7fff, // U+3210...U+321F
    0xfc00, // U+3220...U+322F
    0xffff, // U+3230...U+323F
    0x00ff, // U+3240...U+324F
    0x0001, // U+3250...U+325F
    0xffff, // U+3260...U+326F
    0xffff, // U+3270...U+327F
    0xfc00, // U+3280...U+328F
    0xffff, // U+3290...U+329F
    0xffff, // U+32A0...U+32AF
    0x0001, // U+32B0...U+32BF
    0xffff, // U+32C0...U+32CF
    0xffff, // U+32D0...U+32DF
    0xffff, // U+32E0...U+32EF
    0xffff, // U+32F0...U+32FF
    0xffff, // U+3300...U+330F
    0xffff, // U+3310...U+331F
    0xffff, // U+3320...U+332F
    0xffff, // U+3330...U+333F
    0xffff, // U+3340...U+334F
    0xffff, // U+3350...U+335F
    0xffff, // U+3360...U+336F
    0xffff, // U+3370...U+337F
    0xffff, // U+3380...U+338F
    0xffff, // U+3390...U+339F
    0xffff, // U+33A0...U+33AF
    0xffff, // U+33B0...U+33BF
    0xffff, // U+33C0...U+33CF
    0xffff, // U+33D0...U+33DF
    0xffff, // U+33E0...U+33EF
    0xffff, // U+33F0...U+33FF
    0xffff, // U+4DC0...U+4DCF
    0xffff, // U+4DD0...U+4DDF
    0xffff, // U+4DE0...U+4DEF
    0xffff, // U+4DF0...U+4DFF
    0xffff, // U+A490...U+A49F
    0xffff, // U+A4A0...U+A4AF
    0xffff, // U+A4B0...U+A4BF
    0x007f, // U+A4C0...U+A4CF
    0xc000, // U+A4F0...U+A4FF
    0xe000, // U+A600...U+A60F
    0x4008, // U+A670...U+A67F
    0x00fc, // U+A6F0...U+A6FF
    0xffff, // U+A700...U+A70F
    0x007f, // U+A710...U+A71F
    0x0003, // U+A720...U+A72F
    0x0600, // U+A780...U+A78F
    0x0f00, // U+A820...U+A82F
    0x03c0, // U+A830...U+A83F
    0x00f0, // U+A870...U+A87F
    0xc000, // U+A8C0...U+A8CF
    0x1700, // U+A8F0...U+A8FF
    0xc000, // U+A920...U+A92F
    0x8000, // U+A950...U+A95F
    0x3ffe, // U+A9C0...U+A9CF
    0xc000, // U+A9D0...U+A9DF
    0xf000, // U+AA50...U+AA5F
    0x0380, // U+AA70...U+AA7F
    0xc000, // U+AAD0...U+AADF
    0x0003, // U+AAF0...U+AAFF
    0x0800, // U+AB50...U+AB5F
    0x0c00, // U+AB60...U+AB6F
    0x0800, // U+ABE0...U+ABEF
    0x0200, // U+FB20...U+FB2F
    0xfffc, // U+FBB0...U+FBBF
    0x0007, // U+FBC0...U+FBCF
    0xc000, // U+FD30...U+FD3F
    0xffff, // U+FD40...U+FD4F
    0x8000, // U+FDC0...U+FDCF
    0xf000, // U+FDF0...U+FDFF
    0x03ff, // U+FE10...U+FE1F
    0xffff, // U+FE30...U+FE3F
    0xffff, // U+FE40...U+FE4F
    0xfff7, // U+FE50...U+FE5F
    0x0f7f, // U+FE60...U+FE6F
    0xfffe, // U+FF00...U+FF0F
    0xfc00, // U+FF10...U+FF1F
    0x0001, // U+FF20...U+FF2F
    0xf800, // U+FF30...U+FF3F
    0x0001, // U+FF40...U+FF4F
    0xf800, // U+FF50...U+FF5F
    0x003f, // U+FF60...U+FF6F
    0x7f7f, // U+FFE0...U+FFEF
    0x3000, // U+FFF0...U+FFFF
    0x0007, // U+10100...U+1010F
    0xff80, // U+10130...U+1013F
    0xfe00, // U+10170...U+1017F
    0x73ff, // U+10180...U+1018F
    0x1fff, // U+10190...U+1019F
    0x0001, // U+101A0...U+101AF
    0xffff, // U+101D0...U+101DF
    0xffff, // U+101E0...U+101EF
    0x1fff, // U+101F0...U+101FF
    0x8000, // U+10390...U+1039F
    0x0001, // U+103D0...U+103DF
    0x8000, // U+10560...U+1056F
    0x0080, // U+10850...U+1085F
    0x0180, // U+10870...U+1087F
    0x8000, // U+10910...U+1091F
    0x8000, // U+10930...U+1093F
    0x01ff, // U+10A50...U+10A5F
    0x8000, // U+10A70...U+10A7F
    0x0100, // U+10AC0...U+10ACF
    0x007f, // U+10AF0...U+10AFF
    0xfe00, // U+10B30...U+10B3F
    0x1e00, // U+10B90...U+10B9F
    0x2000, // U+10EA0...U+10EAF
    0x03e0, // U+10F50...U+10F5F
    0x03c0, // U+10F80...U+10F8F
    0x3f80, // U+11040...U+1104F
    0xd800, // U+110B0...U+110BF
    0x0003, // U+110C0...U+110CF
    0x000f, // U+11140...U+1114F
    0x0030, // U+11170...U+1117F
    0x21e0, // U+111C0...U+111CF
    0xe800, // U+111D0...U+111DF
    0x3f00, // U+11230...U+1123F
    0x0200, // U+112A0...U+112AF
    0xf800, // U+11440...U+1144F
    0x2c00, // U+11450...U+1145F
    0x0040, // U+114C0...U+114CF
    0xfffe, // U+115C0...U+115CF
    0x00ff, // U+115D0...U+115DF
    0x000e, // U+11640...U+1164F
    0x1fff, // U+11660...U+1166F
    0x0200, // U+116B0...U+116BF
    0xf000, // U+11730...U+1173F
    0x0800, // U+11830...U+1183F
    0x0070, // U+11940...U+1194F
    0x0004, // U+119E0...U+119EF
    0x8000, // U+11A30...U+11A3F
    0x007f, // U+11A40...U+11A4F
    0xdc00, // U+11A90...U+11A9F
    0x0007, // U+11AA0...U+11AAF
    0x03ff, // U+11B00...U+11B0F
    0x003e, // U+11C40...U+11C4F
    0x0003, // U+11C70...U+11C7F
    0x0180, // U+11EF0...U+11EFF
    0xfff8, // U+11F40...U+11F4F
    0xffe0, // U+11FD0...U+11FDF
    0xffff, // U+11FE0...U+11FEF
    0x8003, // U+11FF0...U+11FFF
    0x001f, // U+12470...U+1247F
    0x0006, // U+12FF0...U+12FFF
    0xc000, // U+16A60...U+16A6F
    0x0020, // U+16AF0...U+16AFF
    0xff80, // U+16B30...U+16B3F
    0x0030, // U+16B40...U+16B4F
    0x0780, // U+16E90...U+16E9F
    0x0004, // U+16FE0...U+16FEF
    0x9000, // U+1BC90...U+1BC9F
    0xffff, // U+1CF50...U+1CF5F
    0xffff, // U+1CF60...U+1CF6F
    0xffff, // U+1CF70...U+1CF7F
    0xffff, // U+1CF80...U+1CF8F
    0xffff, // U+1CF90...U+1CF9F
    0xffff, // U+1CFA0...U+1CFAF
    0xffff, // U+1CFB0...U+1CFBF
    0x000f, // U+1CFC0...U+1CFCF
    0xffff, // U+1D000...U+1D00F
    0xffff, // U+1D010...U+1D01F
    0xffff, // U+1D020...U+1D02F
    0xffff, // U+1D030...U+1D03F
    0xffff, // U+1D040...U+1D04F
    0xffff, // U+1D050...U+1D05F
    0xffff, // U+1D060...U+1D06F
    0xffff, // U+1D070...U+1D07F
    0xffff, // U+1D080...U+1D08F
    0xffff, // U+1D090...U+1D09F
    0xffff, // U+1D0A0...U+1D0AF
    0xffff, // U+1D0B0...U+1D0BF
    0xffff, // U+1D0C0...U+1D0CF
    0xffff, // U+1D0D0...U+1D0DF
    0xffff, // U+1D0E0...U+1D0EF
    0x003f, // U+1D0F0...U+1D0FF
    0xffff, // U+1D100...U+1D10F
    0xffff, // U+1D110...U+1D11F
    0xfe7f, // U+1D120...U+1D12F
    0xffff, // U+1D130...U+1D13F
    0xffff, // U+1D140...U+1D14F
    0xffff, // U+1D150...U+1D15F
    0x1c1f, // U+1D160...U+1D16F
    0xf018, // U+1D180...U+1D18F
    0xffff, // U+1D190...U+1D19F
    0xc3ff, // U+1D1A0...U+1D1AF
    0xffff, // U+1D1B0...U+1D1BF
    0xffff, // U+1D1C0...U+1D1CF
    0xffff, // U+1D1D0...U+1D1DF
    0x07ff, // U+1D1E0...U+1D1EF
    0xffff, // U+1D200...U+1D20F
    0xffff, // U+1D210...U+1D21F
    0xffff, // U+1D220...U+1D22F
    0xffff, // U+1D230...U+1D23F
    0x0023, // U+1D240...U+1D24F
    0xffff, // U+1D300...U+1D30F
    0xffff, // U+1D310...U+1D31F
    0xffff, // U+1D320...U+1D32F
    0xffff, // U+1D330...U+1D33F
    0xffff, // U+1D340...U+1D34F
    0x007f, // U+1D350...U+1D35F
    0x0002, // U+1D6C0...U+1D6CF
    0x0800, // U+1D6D0...U+1D6DF
    0x0800, // U+1D6F0...U+1D6FF
    0x0020, // U+1D710...U+1D71F
    0x0020, // U+1D730...U+1D73F
    0x8000, // U+1D740...U+1D74F
    0x8000, // U+1D760...U+1D76F
    0x0200, // U+1D780...U+1D78F
    0x0200, // U+1D7A0...U+1D7AF
    0x0008, // U+1D7C0...U+1D7CF
    0xffff, // U+1D800...U+1D80F
    0xffff, // U+1D810...U+1D81F
    0xffff, // U+1D820...U+1D82F
    0xffff, // U+1D830...U+1D83F
    0xffff, // U+1D840...U+1D84F
    0xffff, // U+1D850...U+1D85F
    0xffff, // U+1D860...U+1D86F
    0xffff, // U+1D870...U+1D87F
    0xffff, // U+1D880...U+1D88F
    0xffff, // U+1D890...U+1D89F
    0xffff, // U+1D8A0...U+1D8AF
    0xffff, // U+1D8B0...U+1D8BF
    0xffff, // U+1D8C0...U+1D8CF
    0xffff, // U+1D8D0...U+1D8DF
    0xffff, // U+1D8E0...U+1D8EF
    0xffff, // U+1D8F0...U+1D8FF
    0xffff, // U+1D900...U+1D90F
    0xffff, // U+1D910...U+1D91F
    0xffff, // U+1D920...U+1D92F
    0xffff, // U+1D930...U+1D93F
    0xffff, // U+1D940...U+1D94F
    0xffff, // U+1D950...U+1D95F
    0xffff, // U+1D960...U+1D96F
    0xffff, // U+1D970...U+1D97F
    0xffff, // U+1D980...U+1D98F
    0xffff, // U+1D990...U+1D99F
    0xffff, // U+1D9A0...U+1D9AF
    0xffff, // U+1D9B0...U+1D9BF
    0xffff, // U+1D9C0...U+1D9CF
    0xffff, // U+1D9D0...U+1D9DF
    0xffff, // U+1D9E0...U+1D9EF
    0xffff, // U+1D9F0...U+1D9FF
    0x0780, // U+1DA30...U+1DA3F
    0xe000, // U+1DA60...U+1DA6F
    0xffdf, // U+1DA70...U+1DA7F
    0x0fef, // U+1DA80...U+1DA8F
    0x8000, // U+1E140...U+1E14F
    0x8000, // U+1E2F0...U+1E2FF
    0xc000, // U+1E950...U+1E95F
    0x1000, // U+1ECA0...U+1ECAF
    0x0001, // U+1ECB0...U+1ECBF
    0x4000, // U+1ED20...U+1ED2F
    0x0003, // U+1EEF0...U+1EEFF
    0xffff, // U+1F000...U+1F00F
    0xffff, // U+1F010...U+1F01F
    0x0fff, // U+1F020...U+1F02F
    0xffff, // U+1F030...U+1F03F
    0xffff, // U+1F040...U+1F04F
    0xffff, // U+1F050...U+1F05F
    0xffff, // U+1F060...U+1F06F
    0xffff, // U+1F070...U+1F07F
    0xffff, // U+1F080...U+1F08F
    0x000f, // U+1F090...U+1F09F
    0x7fff, // U+1F0A0...U+1F0AF
    0xfffe, // U+1F0B0...U+1F0BF
    0xfffe, // U+1F0C0...U+1F0CF
    0xfffe, // U+1F0D0...U+1F0DF
    0xffff, // U+1F0E0...U+1F0EF
    0x003f, // U+1F0F0...U+1F0FF
    0xe000, // U+1F100...U+1F10F
    0xffff, // U+1F110...U+1F11F
    0xffff, // U+1F120...U+1F12F
    0xffff, // U+1F130...U+1F13F
    0xffff, // U+1F140...U+1F14F
    0xffff, // U+1F150...U+1F15F
    0xffff, // U+1F160...U+1F16F
    0xffff, // U+1F170...U+1F17F
    0xffff, // U+1F180...U+1F18F
    0xffff, // U+1F190...U+1F19F
    0x3fff, // U+1F1A0...U+1F1AF
    0xffc0, // U+1F1E0...U+1F1EF
    0xffff, // U+1F1F0...U+1F1FF
    0x0007, // U+1F200...U+1F20F
    0xffff, // U+1F210...U+1F21F
    0xffff, // U+1F220...U+1F22F
    0x0fff, // U+1F230...U+1F23F
    0x01ff, // U+1F240...U+1F24F
    0x0003, // U+1F250...U+1F25F
    0x003f, // U+1F260...U+1F26F
    0xffff, // U+1F300...U+1F30F
    0xffff, // U+1F310...U+1F31F
    0xffff, // U+1F320...U+1F32F
    0xffff, // U+1F330...U+1F33F
    0xffff, // U+1F340...U+1F34F
    0xffff, // U+1F350...U+1F35F
    0xffff, // U+1F360...U+1F36F
    0xffff, // U+1F370...U+1F37F
    0xffff, // U+1F380...U+1F38F
    0xffff, // U+1F390...U+1F39F
    0xffff, // U+1F3A0...U+1F3AF
    0xffff, // U+1F3B0...U+1F3BF
    0xffff, // U+1F3C0...U+1F3CF
    0xffff, // U+1F3D0...U+1F3DF
    0xffff, // U+1F3E0...U+1F3EF
    0xffff, // U+1F3F0...U+1F3FF
    0xffff, // U+1F400...U+1F40F
    0xffff, // U+1F410...U+1F41F
    0xffff, // U+1F420...U+1F42F
    0xffff, // U+1F430...U+1F43F
    0xffff, // U+1F440...U+1F44F
    0xffff, // U+1F450...U+1F45F
    0xffff, // U+1F460...U+1F46F
    0xffff, // U+1F470...U+1F47F
    0xffff, // U+1F480...U+1F48F
    0xffff, // U+1F490...U+1F49F
    0xffff, // U+1F4A0...U+1F4AF
    0xffff, // U+1F4B0...U+1F4BF
    0xffff, // U+1F4C0...U+1F4CF
    0xffff, // U+1F4D0...U+1F4DF
    0xffff, // U+1F4E0...U+1F4EF
    0xffff, // U+1F4F0...U+1F4FF
    0xffff, // U+1F500...U+1F50F
    0xffff, // U+1F510...U+1F51F
    0xffff, // U+1F520...U+1F52F
    0xffff, // U+1F530...U+1F53F
    0xffff, // U+1F540...U+1F54F
    0xffff, // U+1F550...U+1F55F
    0xffff, // U+1F560...U+1F56F
    0xffff, // U+1F570...U+1F57F
    0xffff, // U+1F580...U+1F58F
    0xffff, // U+1F590...U+1F59F
    0xffff, // U+1F5A0...U+1F5AF
    0xffff, // U+1F5B0...U+1F5BF
    0xffff, // U+1F5C0...U+1F5CF
    0xffff, // U+1F5D0...U+1F5DF
    0xffff, // U+1F5E0...U+1F5EF
    0xffff, // U+1F5F0...U+1F5FF
    0xffff, // U+1F600...U+1F60F
    0xffff, // U+1F610...U+1F61F
    0xffff, // U+1F620...U+1F62F
    0xffff, // U+1F630...U+1F63F
    0xffff, // U+1F640...U+1F64F
    0xffff, // U+1F650...U+1F65F
    0xffff, // U+1F660...U+1F66F
    0xffff, // U+1F670...U+1F67F
    0xffff, // U+1F680...U+1F68F
    0xffff, // U+1F690...U+1F69F
    0xffff, // U+1F6A0...U+1F6AF
    0xffff, // U+1F6B0...U+1F6BF
    0xffff, // U+1F6C0...U+1F6CF
    0xf0ff, // U+1F6D0...U+1F6DF
    0x1fff, // U+1F6E0...U+1F6EF
    0x1fff, // U+1F6F0...U+1F6FF
    0xffff, // U+1F700...U+1F70F
    0xffff, // U+1F710...U+1F71F
    0xffff, // U+1F720...U+1F72F
    0xffff, // U+1F730...U+1F73F
    0xffff, // U+1F740...U+1F74F
    0xffff, // U+1F750...U+1F75F
    0xffff, // U+1F760...U+1F76F
    0xf87f, // U+1F770...U+1F77F
    0xffff, // U+1F780...U+1F78F
    0xffff, // U+1F790...U+1F79F
    0xffff, // U+1F7A0...U+1F7AF
    0xffff, // U+1F7B0...U+1F7BF
    0xffff, // U+1F7C0...U+1F7CF
    0x03ff, // U+1F7D0...U+1F7DF
    0x0fff, // U+1F7E0...U+1F7EF
    0x0001, // U+1F7F0...U+1F7FF
    0x0fff, // U+1F800...U+1F80F
    0xffff, // U+1F810...U+1F81F
    0xffff, // U+1F820...U+1F82F
    0xffff, // U+1F830...U+1F83F
    0x00ff, // U+1F840...U+1F84F
    0x03ff, // U+1F850...U+1F85F
    0xffff, // U+1F860...U+1F86F
    0xffff, // U+1F870...U+1F87F
    0x00ff, // U+1F880...U+1F88F
    0xffff, // U+1F890...U+1F89F
    0x3fff, // U+1F8A0...U+1F8AF
    0x0003, // U+1F8B0...U+1F8BF
    0xffff, // U+1F900...U+1F90F
    0xffff, // U+1F910...U+1F91F
    0xffff, // U+1F920...U+1F92F
    0xffff, // U+1F930...U+1F93F
    0xffff, // U+1F940...U+1F94F
    0xffff, // U+1F950...U+1F95F
    0xffff, // U+1F960...U+1F96F
    0xffff, // U+1F970...U+1F97F
    0xffff, // U+1F980...U+1F98F
    0xffff, // U+1F990...U+1F99F
    0xffff, // U+1F9A0...U+1F9AF
    0xffff, // U+1F9B0...U+1F9BF
    0xffff, // U+1F9C0...U+1F9CF
    0xffff, // U+1F9D0...U+1F9DF
    0xffff, // U+1F9E0...U+1F9EF
    0xffff, // U+1F9F0...U+1F9FF
    0xffff, // U+1FA00...U+1FA0F
    0xffff, // U+1FA10...U+1FA1F
    0xffff, // U+1FA20...U+1FA2F
    0xffff, // U+1FA30...U+1FA3F
    0xffff, // U+1FA40...U+1FA4F
    0x000f, // U+1FA50...U+1FA5F
    0x3fff, // U+1FA60...U+1FA6F
    0x1fff, // U+1FA70...U+1FA7F
    0x01ff, // U+1FA80...U+1FA8F
    0xffff, // U+1FA90...U+1FA9F
    0xffff, // U+1FAA0...U+1FAAF
    0xbfff, // U+1FAB0...U+1FABF
    0xc03f, // U+1FAC0...U+1FACF
    0x0fff, // U+1FAD0...U+1FADF
    0x01ff, // U+1FAE0...U+1FAEF
    0x01ff, // U+1FAF0...U+1FAFF
    0xffff, // U+1FB00...U+1FB0F
    0xffff, // U+1FB10...U+1FB1F
    0xffff, // U+1FB20...U+1FB2F
    0xffff, // U+1FB30...U+1FB3F
    0xffff, // U+1FB40...U+1FB4F
    0xffff, // U+1FB50...U+1FB5F
    0xffff, // U+1FB60...U+1FB6F
    0xffff, // U+1FB70...U+1FB7F
    0xffff, // U+1FB80...U+1FB8F
    0xfff7, // U+1FB90...U+1FB9F
    0xffff, // U+1FBA0...U+1FBAF
    0xffff, // U+1FBB0...U+1FBBF
    0x07ff, // U+1FBC0...U+1FBCF
];

pub(crate) fn is_ascii_punctuation(c: u8) -> bool {
    c < 128 && (PUNCT_MASKS_ASCII[(c / 16) as usize] & (1 << (c & 15))) != 0
}

pub(crate) fn is_punctuation(c: char) -> bool {
    let cp = c as u32;
    if cp < 128 {
        return is_ascii_punctuation(cp as u8);
    }
    if cp > 0x1FBCA {
        return false;
    }
    let high = (cp / 16) as u16;
    match PUNCT_TAB.binary_search(&high) {
        Ok(index) => (PUNCT_MASKS[index] & (1 << (cp & 15))) != 0,
        _ => false,
    }
}

#[cfg(test)]
mod tests {
    use super::{is_ascii_punctuation, is_punctuation};

    #[test]
    fn test_ascii() {
        assert!(is_ascii_punctuation(b'!'));
        assert!(is_ascii_punctuation(b'@'));
        assert!(is_ascii_punctuation(b'~'));
        assert!(!is_ascii_punctuation(b' '));
        assert!(!is_ascii_punctuation(b'0'));
        assert!(!is_ascii_punctuation(b'A'));
        assert!(!is_ascii_punctuation(0xA1));
    }

    #[test]
    fn test_unicode() {
        assert!(is_punctuation('~'));
        assert!(!is_punctuation(' '));

        assert!(is_punctuation('\u{00A1}'));
        assert!(is_punctuation('\u{060C}'));
        assert!(is_punctuation('\u{FF65}'));
        assert!(is_punctuation('\u{1BC9F}'));
        assert!(!is_punctuation('\u{1BCA0}'));
    }
}
