# 2022-11-29 Triage Log

A relatively quiet week for performance, with the notable exception of "Avoid
`GenFuture` shim when compiling async constructs [#104321](https://github.com/rust-lang/rust/pull/104321)"
 which brought sizeable wins on a number of stress test benchmarks. It probably
won't be of huge benefit to most codebases, but should provide smaller wins to
folks with large amounts of async-generated futures.

Triage done by **@simulacrum**.
Revision range: [a78c9bee4d9d51a3891bd8ecae1f28a93b83653b..8a09420ac48658cad726e0a6997687ceac4151e3](https://perf.rust-lang.org/?start=a78c9bee4d9d51a3891bd8ecae1f28a93b83653b&end=8a09420ac48658cad726e0a6997687ceac4151e3&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.3%, 1.5%]    | 11    |
| Regressions ❌ <br /> (secondary)  | 1.8%  | [0.4%, 3.0%]    | 25    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.8%, -0.3%]  | 148   |
| Improvements ✅ <br /> (secondary) | -6.7% | [-87.7%, -0.3%] | 107   |
| All ❌✅ (primary)                 | -0.9% | [-3.8%, 1.5%]   | 159   |


3 Regressions, 3 Improvements, 6 Mixed; 2 of them in rollups
43 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#104758](https://github.com/rust-lang/rust/pull/104758) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=008bc1d587b4f9d7197eb159922dd2080eea9284&end=3f2b2eee8f46f2252d2919d7a57bf3068d7df285&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.3%] | 1     |
| Regressions ❌ <br /> (secondary)  | 2.1% | [0.6%, 7.1%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.3%] | 1     |

This PR was a perf regression (see the report here
https://github.com/rust-lang/rust/pull/104758#issuecomment-1325100344). It's
relatively small and mostly limited to secondary workloads so I'm marking as
triaged.

Branch Clause from Predicate [#104846](https://github.com/rust-lang/rust/pull/104846) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e704e95250ff4e949214f390a88f21d08052bea1&end=051cab2b842113b18da28259f4b85d0a7556f7f1&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.2%, 2.4%] | 38    |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.8%] | 5     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.2%, 2.4%] | 38    |

Unexpected regression, PR reviewer and author are going to look into it.

Add `ConstKind::Expr` [#99798](https://github.com/rust-lang/rust/pull/99798) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8681d4cffcd23bbe619984ab62772a91827a40dc&end=aff003becd8b6bf803202e958623031274ad69c9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.5%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.3%, 1.6%]   | 21    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.5%]   | 6     |

Previous perf runs showed slight improvements, but the post-merge one shows regressions. They are mostly among secondary benchmarks.

#### Improvements

Fix perf regression by correctly matching keywords [#104410](https://github.com/rust-lang/rust/pull/104410)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d121aa3b5584eb919a4aaf64dbae0ea1e8e30231&end=70f8737b2f5d3bf7d6b784fad00b663b7ff9feda&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 32    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.1%, -0.5%] | 8     |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 32    |


Use an IndexVec to cache queries with index-like key [#103808](https://github.com/rust-lang/rust/pull/103808) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd815a5091eb4d49cd317f8ad272f17b7a5f550d&end=341d8b8a2c290b4535e965867e876b095461ff6e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.3%, -0.2%] | 133   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-7.8%, -0.2%] | 105   |
| All ❌✅ (primary)                 | -0.8% | [-2.3%, -0.2%] | 133   |


Avoid `GenFuture` shim when compiling async constructs [#104321](https://github.com/rust-lang/rust/pull/104321) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1dda298ad39a64e019a3511139c5b13ac0a18e54&end=5dfb4b0afaf6acace0845d00e85a934fb4289d83&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -      | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -      | -               | 0     |
| Improvements ✅ <br /> (primary)   | -      | -               | 0     |
| Improvements ✅ <br /> (secondary) | -28.0% | [-87.8%, -1.9%] | 22    |
| All ❌✅ (primary)                 | -      | -               | 0     |


#### Mixed

optimize field ordering by grouping `m*2^n`-sized fields with equivalently aligned ones [#102750](https://github.com/rust-lang/rust/pull/102750) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3f2b2eee8f46f2252d2919d7a57bf3068d7df285&end=4e0d0d757e2f1b61ec809420b006545a9f8974c0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 0.8%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.3%, 2.3%]   | 26    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-2.2%, -0.2%] | 44    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.2%, -0.1%] | 22    |
| All ❌✅ (primary)                 | -0.4% | [-2.2%, 0.8%]  | 48    |

Some followup discussion on https://github.com/rust-lang/rust/issues/104807 but
overall a roughly neutral change.

privacy: Fix more (potential) issues with effective visibilities [#104602](https://github.com/rust-lang/rust/pull/104602)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=af63e3b39f3990418ad8e0a1b1fa8a722a7c50b0&end=41e0363055ade59584cff667c79f64937e6ef3f9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [0.3%, 3.6%]   | 17    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.4%, -0.5%] | 13    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.5% | [-1.4%, 0.3%]  | 21    |

> This fixes correctness issues, and the regressions are mostly in
> unused-warnings which is a stress test where 3% doesn't really matter. Plus
> libc got a bit faster. So overall, not a performance concern.

Manually implement PartialEq for `Option<T>` and specialize non-nullable types [#103556](https://github.com/rust-lang/rust/pull/103556)
 [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f8a2e491ebec34113563cf8683f6fec2646cebb1&end=8841bee954ecf0e6820c9990feb3a76cb04e7d96&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.1%  | [2.1%, 2.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [-0.4%, 2.1%]  | 3     |

Relatively few relatively small changes, no further investigation needed.

Stop peeling the last iteration of the loop in `Vec::resize_with` [#104818](https://github.com/rust-lang/rust/pull/104818)
 [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c0e9c86b3f3e96267ba2cd80f95f362ef0cce40b&end=faf1891deb2633fe4040de8b71fd7b2045c45dc5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.8%, 0.8%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.1%] | 7     |
| All ❌✅ (primary)                 | -0.0% | [-0.3%, 0.8%]  | 4     |

> Perf changes are very small, and wins slightly outweigh losses.

Update VecDeque implementation to use head+len instead of head+tail [#102991](https://github.com/rust-lang/rust/pull/102991)
 [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dd12cd6dc631b5e964d541d370ca863c2242376c&end=69df0f2c2f665d7f4e38a3579a81d4efc0d81034&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 1.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 3     |

Performance looks like overall neutral to slight win.

Rollup of 6 pull requests [#105008](https://github.com/rust-lang/rust/pull/105008)
 [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=69df0f2c2f665d7f4e38a3579a81d4efc0d81034&end=8a09420ac48658cad726e0a6997687ceac4151e3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 0.9%]   | 8     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-0.9%, -0.8%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.4% | [-2.7%, -2.1%] | 6     |
| All ❌✅ (primary)                 | 0.3%  | [-0.9%, 0.9%]  | 10    |

keccak improvements may be spurious but overall neutral so no further investigation warranted.
